/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.exceptions;

import org.zalando.nakadi.domain.Cursor;
import org.zalando.nakadi.domain.CursorError;

public class InvalidCursorException
extends Exception {
    private final CursorError error;
    private final Cursor cursor;

    public InvalidCursorException(CursorError error, Cursor cursor) {
        this.error = error;
        this.cursor = cursor;
    }

    public CursorError getError() {
        return this.error;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public String getMessage() {
        switch (this.error) {
            case PARTITION_NOT_FOUND: {
                return "non existing partition " + this.cursor.getPartition();
            }
            case EMPTY_PARTITION: {
                return "partition " + this.cursor.getPartition() + " is empty";
            }
            case UNAVAILABLE: {
                return "offset " + this.cursor.getOffset() + " for partition " + this.cursor.getPartition() + " is unavailable";
            }
            case NULL_OFFSET: {
                return "offset must not be null";
            }
            case NULL_PARTITION: {
                return "partition must not be null";
            }
        }
        return "invalid offset " + this.cursor.getOffset() + " for partition " + this.cursor.getPartition();
    }
}

