/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class MonitoringRequestFilter
implements Filter {
    private final Timer httpConnectionsTimer;
    private final Counter openHttpConnectionsCounter;

    public MonitoringRequestFilter(MetricRegistry metricRegistry) {
        this.openHttpConnectionsCounter = metricRegistry.counter("nakadi.general.openSynchronousHttpConnections");
        this.httpConnectionsTimer = metricRegistry.timer("nakadi.general.synchronousHttpConnections");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.openHttpConnectionsCounter.inc();
        Timer.Context timerContext = this.httpConnectionsTimer.time();
        try {
            chain.doFilter(request, response);
        }
        finally {
            timerContext.stop();
            this.openHttpConnectionsCounter.dec();
        }
    }

    public void destroy() {
    }
}

