/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository;

import java.util.List;
import java.util.Map;
import org.zalando.nakadi.domain.BatchItem;
import org.zalando.nakadi.domain.Cursor;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.SubscriptionBase;
import org.zalando.nakadi.domain.Topic;
import org.zalando.nakadi.domain.TopicPartition;
import org.zalando.nakadi.exceptions.DuplicatedEventTypeNameException;
import org.zalando.nakadi.exceptions.EventPublishingException;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.InvalidCursorException;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.ServiceUnavailableException;
import org.zalando.nakadi.exceptions.TopicCreationException;
import org.zalando.nakadi.exceptions.TopicDeletionException;
import org.zalando.nakadi.repository.EventConsumer;

public interface TopicRepository {
    public List<Topic> listTopics() throws NakadiException;

    public void createTopic(EventType var1) throws TopicCreationException, DuplicatedEventTypeNameException;

    public void deleteTopic(String var1) throws TopicDeletionException;

    public boolean topicExists(String var1) throws NakadiException;

    public boolean partitionExists(String var1, String var2) throws NakadiException;

    public void syncPostBatch(String var1, List<BatchItem> var2) throws EventPublishingException;

    public List<TopicPartition> listPartitions(String var1) throws NakadiException;

    public Map<String, Long> materializePositions(String var1, SubscriptionBase.InitialPosition var2) throws ServiceUnavailableException;

    public List<String> listPartitionNames(String var1);

    public TopicPartition getPartition(String var1, String var2) throws NakadiException;

    public EventConsumer createEventConsumer(String var1, List<Cursor> var2) throws NakadiException, InvalidCursorException;

    public int compareOffsets(String var1, String var2) throws InternalNakadiException;

    public void validateCommitCursors(String var1, List<Cursor> var2) throws InvalidCursorException;
}

