/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.db;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.domain.Subscription;
import org.zalando.nakadi.domain.SubscriptionBase;
import org.zalando.nakadi.exceptions.DuplicatedSubscriptionException;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.NoSuchSubscriptionException;
import org.zalando.nakadi.repository.db.AbstractDbRepository;
import org.zalando.nakadi.util.UUIDGenerator;

@Component
@Profile(value={"!test"})
public class SubscriptionDbRepository
extends AbstractDbRepository {
    private final SubscriptionMapper rowMapper = new SubscriptionMapper();
    private final UUIDGenerator uuidGenerator;

    @Autowired
    public SubscriptionDbRepository(JdbcTemplate jdbcTemplate, ObjectMapper objectMapper, UUIDGenerator uuidGenerator) {
        super(jdbcTemplate, objectMapper);
        this.uuidGenerator = uuidGenerator;
    }

    public Subscription createSubscription(SubscriptionBase subscriptionBase) throws InternalNakadiException, DuplicatedSubscriptionException {
        try {
            String newId = this.uuidGenerator.randomUUID().toString();
            DateTime createdAt = new DateTime(DateTimeZone.UTC);
            Subscription subscription = new Subscription(newId, createdAt, subscriptionBase);
            this.jdbcTemplate.update("INSERT INTO zn_data.subscription (s_id, s_subscription_object) VALUES (?, ?::jsonb)", new Object[]{subscription.getId(), this.jsonMapper.writer().writeValueAsString((Object)subscription)});
            return subscription;
        }
        catch (JsonProcessingException e) {
            throw new InternalNakadiException("Serialization problem during persistence of event type", (Exception)((Object)e));
        }
        catch (DuplicateKeyException e) {
            throw new DuplicatedSubscriptionException("Subscription with the same key properties already exists", (Exception)((Object)e));
        }
    }

    public Subscription getSubscription(String id) throws NoSuchSubscriptionException {
        String sql = "SELECT s_subscription_object FROM zn_data.subscription WHERE s_id = ?";
        try {
            return (Subscription)this.jdbcTemplate.queryForObject("SELECT s_subscription_object FROM zn_data.subscription WHERE s_id = ?", new Object[]{id}, (RowMapper)this.rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchSubscriptionException("Subscription with id \"" + id + "\" does not exist", (Exception)((Object)e));
        }
    }

    public Subscription getSubscription(String owningApplication, Set<String> eventTypes, String consumerGroup) throws NoSuchSubscriptionException, InternalNakadiException {
        String sql = "SELECT s_subscription_object FROM zn_data.subscription WHERE s_subscription_object->>'owning_application' = ? AND replace(s_subscription_object->>'event_types', ' ', '') = ? AND s_subscription_object->>'consumer_group' = ? ";
        try {
            String eventTypesJson = this.jsonMapper.writer().writeValueAsString((Object)Sets.newTreeSet(eventTypes));
            return (Subscription)this.jdbcTemplate.queryForObject("SELECT s_subscription_object FROM zn_data.subscription WHERE s_subscription_object->>'owning_application' = ? AND replace(s_subscription_object->>'event_types', ' ', '') = ? AND s_subscription_object->>'consumer_group' = ? ", new Object[]{owningApplication, eventTypesJson, consumerGroup}, (RowMapper)this.rowMapper);
        }
        catch (JsonProcessingException e) {
            throw new InternalNakadiException("Serialization problem during getting event type", (Exception)((Object)e));
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchSubscriptionException("Subscription does not exist", (Exception)((Object)e));
        }
    }

    private class SubscriptionMapper
    implements RowMapper<Subscription> {
        private SubscriptionMapper() {
        }

        public Subscription mapRow(ResultSet rs, int rowNum) throws SQLException {
            try {
                return (Subscription)SubscriptionDbRepository.this.jsonMapper.readValue(rs.getString("s_subscription_object"), Subscription.class);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }
}

