/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.zookeeper;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.DefaultExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class ZooKeeperHolder {
    private final String zookeeperBrokers;
    private final String zookeeperKafkaNamespace;
    private final String exhibitorAddresses;
    private final Integer exhibitorPort;
    private CuratorFramework zooKeeper;

    public ZooKeeperHolder(String zookeeperBrokers, String zookeeperKafkaNamespace, String exhibitorAddresses, Integer exhibitorPort) {
        this.zookeeperBrokers = zookeeperBrokers;
        this.zookeeperKafkaNamespace = zookeeperKafkaNamespace;
        this.exhibitorAddresses = exhibitorAddresses;
        this.exhibitorPort = exhibitorPort;
    }

    @PostConstruct
    public void init() throws Exception {
        Object ensembleProvider;
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        if (this.exhibitorAddresses != null) {
            List<String> exhibitorHosts = Arrays.asList(this.exhibitorAddresses.split("\\s*,\\s*"));
            Exhibitors exhibitors = new Exhibitors(exhibitorHosts, this.exhibitorPort.intValue(), () -> this.zookeeperBrokers + this.zookeeperKafkaNamespace);
            DefaultExhibitorRestClient exhibitorRestClient = new DefaultExhibitorRestClient();
            ensembleProvider = new ExhibitorEnsembleProvider(exhibitors, (ExhibitorRestClient)exhibitorRestClient, "/exhibitor/v1/cluster/list", 300000, (RetryPolicy)retryPolicy);
            ((ExhibitorEnsembleProvider)((Object)ensembleProvider)).pollForInitialEnsemble();
        } else {
            ensembleProvider = new FixedEnsembleProvider(this.zookeeperBrokers + this.zookeeperKafkaNamespace);
        }
        this.zooKeeper = CuratorFrameworkFactory.builder().ensembleProvider((EnsembleProvider)ensembleProvider).retryPolicy((RetryPolicy)retryPolicy).build();
        this.zooKeeper.start();
    }

    public CuratorFramework get() {
        return this.zooKeeper;
    }

    class ExhibitorEnsembleProvider
    extends org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider {
        public ExhibitorEnsembleProvider(Exhibitors exhibitors, ExhibitorRestClient restClient, String restUriPath, int pollingMs, RetryPolicy retryPolicy) {
            super(exhibitors, restClient, restUriPath, pollingMs, retryPolicy);
        }

        public String getConnectionString() {
            return super.getConnectionString() + ZooKeeperHolder.this.zookeeperKafkaNamespace;
        }
    }
}

