/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service;

import javax.ws.rs.core.Response;
import org.zalando.problem.Problem;

public interface Result<T> {
    public boolean isSuccessful();

    public T getValue();

    public Problem getProblem();

    public static <T> Result<T> problem(Problem problem) {
        return new Failure(problem);
    }

    public static Result<Void> ok() {
        return new Success<Object>(null);
    }

    public static <T> Result<T> ok(T value) {
        return new Success<T>(value);
    }

    public static Result<Void> forbidden(String message) {
        return Result.problem((Problem)Problem.valueOf((Response.StatusType)Response.Status.FORBIDDEN, (String)message));
    }

    public static Result<Void> notFound(String message) {
        return Result.problem((Problem)Problem.valueOf((Response.StatusType)Response.Status.NOT_FOUND, (String)message));
    }

    public static class Failure<T>
    implements Result<T> {
        private final Problem problem;

        public Failure(Problem problem) {
            this.problem = problem;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public T getValue() {
            throw new IllegalArgumentException("Failure.getValue");
        }

        @Override
        public Problem getProblem() {
            return this.problem;
        }
    }

    public static class Success<V>
    implements Result<V> {
        private final V value;

        public Success(V value) {
            this.value = value;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public Problem getProblem() {
            throw new IllegalArgumentException("Success.getProblem");
        }
    }
}

