/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.Subscription;
import org.zalando.nakadi.exceptions.ExceptionWrapper;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.TopicRepository;
import org.zalando.nakadi.repository.kafka.KafkaTopicRepository;
import org.zalando.nakadi.service.subscription.model.Partition;

public class KafkaClient {
    private final Subscription subscription;
    private final KafkaTopicRepository topicRepository;
    private final EventTypeRepository eventTypeRepository;

    public KafkaClient(Subscription subscription, TopicRepository topicRepository, EventTypeRepository eventTypeRepository) {
        this.subscription = subscription;
        this.topicRepository = (KafkaTopicRepository)topicRepository;
        this.eventTypeRepository = eventTypeRepository;
    }

    public Map<Partition.PartitionKey, Long> getSubscriptionOffsets() {
        HashMap<Partition.PartitionKey, Long> offsets = new HashMap<Partition.PartitionKey, Long>();
        try {
            for (String eventTypeName : this.subscription.getEventTypes()) {
                EventType eventType = this.eventTypeRepository.findByName(eventTypeName);
                String topic = eventType.getTopic();
                this.topicRepository.materializePositions(topic, this.subscription.getStartFrom()).entrySet().forEach(e -> offsets.put(new Partition.PartitionKey(topic, (String)e.getKey()), (Long)e.getValue() - 1L));
            }
            return offsets;
        }
        catch (NakadiException e2) {
            throw new ExceptionWrapper(e2);
        }
    }

    public Consumer<String, String> createKafkaConsumer() {
        return this.topicRepository.createKafkaConsumer();
    }
}

