/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.zalando.nakadi.domain.Subscription;
import org.zalando.nakadi.exceptions.NoSuchSubscriptionException;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.db.SubscriptionDbRepository;
import org.zalando.nakadi.repository.kafka.KafkaTopicRepository;
import org.zalando.nakadi.repository.zookeeper.ZooKeeperHolder;
import org.zalando.nakadi.service.subscription.ExactWeightRebalancer;
import org.zalando.nakadi.service.subscription.KafkaClient;
import org.zalando.nakadi.service.subscription.StreamParameters;
import org.zalando.nakadi.service.subscription.StreamingContext;
import org.zalando.nakadi.service.subscription.SubscriptionOutput;
import org.zalando.nakadi.service.subscription.SubscriptionStreamer;
import org.zalando.nakadi.service.subscription.model.Session;
import org.zalando.nakadi.service.subscription.zk.CuratorZkSubscriptionClient;

@Service
public class SubscriptionStreamerFactory {
    @Value(value="${nakadi.kafka.poll.timeoutMs}")
    private long kafkaPollTimeout;
    private final ZooKeeperHolder zkHolder;
    private final SubscriptionDbRepository subscriptionDbRepository;
    private final KafkaTopicRepository topicRepository;
    private final EventTypeRepository eventTypeRepository;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @Autowired
    public SubscriptionStreamerFactory(ZooKeeperHolder zkHolder, SubscriptionDbRepository subscriptionDbRepository, KafkaTopicRepository topicRepository, EventTypeRepository eventTypeRepository) {
        this.zkHolder = zkHolder;
        this.subscriptionDbRepository = subscriptionDbRepository;
        this.topicRepository = topicRepository;
        this.eventTypeRepository = eventTypeRepository;
    }

    public SubscriptionStreamer build(String subscriptionId, StreamParameters streamParameters, SubscriptionOutput output, AtomicBoolean connectionReady) throws NoSuchSubscriptionException {
        Subscription subscription = this.subscriptionDbRepository.getSubscription(subscriptionId);
        Session session = Session.generate(1);
        String loggingPath = "subscription." + subscriptionId + "." + session.getId();
        return new StreamingContext(output, streamParameters, session, this.executorService, new CuratorZkSubscriptionClient(subscription.getId(), this.zkHolder.get(), loggingPath), new KafkaClient(subscription, this.topicRepository, this.eventTypeRepository), new ExactWeightRebalancer(), this.kafkaPollTimeout, loggingPath, connectionReady);
    }
}

