/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.model;

import java.util.Collection;
import javax.annotation.Nullable;

public class Partition {
    private final PartitionKey key;
    private final String session;
    private final String nextSession;
    private final State state;

    public Partition(PartitionKey key, @Nullable String session, @Nullable String nextSession, State state) {
        this.key = key;
        this.session = session;
        this.nextSession = nextSession;
        this.state = state;
    }

    public Partition toState(State state, @Nullable String session, @Nullable String nextSession) {
        return new Partition(this.key, session, nextSession, state);
    }

    public Partition moveToSessionId(String sessionId, Collection<String> existingSessionIds) {
        switch (this.state) {
            case UNASSIGNED: {
                return this.toState(State.ASSIGNED, sessionId, null);
            }
            case ASSIGNED: 
            case REASSIGNING: {
                if (sessionId.equals(this.session)) {
                    return this.toState(State.ASSIGNED, sessionId, null);
                }
                if (!existingSessionIds.contains(this.session)) {
                    return this.toState(State.ASSIGNED, sessionId, null);
                }
                return this.toState(State.REASSIGNING, this.session, sessionId);
            }
        }
        throw new IllegalStateException("Unsupported current state " + (Object)((Object)this.state));
    }

    public boolean mustBeRebalanced(Collection<String> activeSessionIds) {
        switch (this.state) {
            case UNASSIGNED: {
                return true;
            }
            case ASSIGNED: {
                return !activeSessionIds.contains(this.session);
            }
            case REASSIGNING: {
                return !activeSessionIds.contains(this.session) || !activeSessionIds.contains(this.nextSession);
            }
        }
        throw new IllegalStateException("State of partition " + (Object)((Object)this.state) + " is not supported");
    }

    public PartitionKey getKey() {
        return this.key;
    }

    public State getState() {
        return this.state;
    }

    @Nullable
    public String getSession() {
        return this.session;
    }

    @Nullable
    public String getNextSession() {
        return this.nextSession;
    }

    @Nullable
    public String getSessionOrNextSession() {
        if (this.state == State.REASSIGNING) {
            return this.nextSession;
        }
        return this.session;
    }

    public String toString() {
        return this.key + "->" + (Object)((Object)this.state) + ":" + this.session + "->" + this.nextSession;
    }

    public static enum State {
        UNASSIGNED,
        REASSIGNING,
        ASSIGNED;

    }

    public static class PartitionKey {
        public final String topic;
        public final String partition;

        public PartitionKey(String topic, String partition) {
            this.topic = topic;
            this.partition = partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionKey that = (PartitionKey)o;
            return this.topic.equals(that.topic) && this.partition.equals(that.partition);
        }

        public int hashCode() {
            int result = this.topic.hashCode();
            result = 31 * result + this.partition.hashCode();
            return result;
        }

        public String toString() {
            return "{" + this.topic + ':' + this.partition + '}';
        }
    }
}

