/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.state;

import java.io.IOException;
import org.zalando.nakadi.exceptions.NoStreamingSlotsAvailable;
import org.zalando.nakadi.service.subscription.model.Partition;
import org.zalando.nakadi.service.subscription.model.Session;
import org.zalando.nakadi.service.subscription.state.CleanupState;
import org.zalando.nakadi.service.subscription.state.State;
import org.zalando.nakadi.service.subscription.state.StreamingState;

public class StartingState
extends State {
    @Override
    public void onEnter() {
        this.getZk().runLocked(this::createSubscriptionLocked);
    }

    private void createSubscriptionLocked() {
        if (this.getZk().createSubscription()) {
            this.getZk().fillEmptySubscription(this.getKafka().getSubscriptionOffsets());
        } else {
            Partition[] partitions;
            Session[] sessions = this.getZk().listSessions();
            if (sessions.length >= (partitions = this.getZk().listPartitions()).length) {
                this.switchState(new CleanupState(new NoStreamingSlotsAvailable(partitions.length)));
                return;
            }
        }
        this.registerSession();
        try {
            this.getOut().onInitialized(this.getSessionId());
            this.switchState(new StreamingState());
        }
        catch (IOException e) {
            this.getLog().error("Failed to notify of initialization. Switch to cleanup directly", (Throwable)e);
            this.switchState(new CleanupState(e));
        }
    }
}

