/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.state;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadi.service.subscription.KafkaClient;
import org.zalando.nakadi.service.subscription.StreamParameters;
import org.zalando.nakadi.service.subscription.StreamingContext;
import org.zalando.nakadi.service.subscription.SubscriptionOutput;
import org.zalando.nakadi.service.subscription.zk.ZkSubscriptionClient;

public abstract class State {
    private StreamingContext context;
    private Logger log;

    public void setContext(StreamingContext context, String loggingPath) {
        this.context = context;
        this.log = LoggerFactory.getLogger((String)(loggingPath + "." + this.getClass().getSimpleName()));
    }

    public Logger getLog() {
        return this.log;
    }

    public abstract void onEnter();

    public void onExit() {
    }

    private boolean isCurrent() {
        return this.context.isInState(this);
    }

    protected long getKafkaPollTimeout() {
        return this.context.getKafkaPollTimeout();
    }

    protected StreamParameters getParameters() {
        return this.context.getParameters();
    }

    protected ZkSubscriptionClient getZk() {
        return this.context.getZkClient();
    }

    protected KafkaClient getKafka() {
        return this.context.getKafkaClient();
    }

    protected String getSessionId() {
        return this.context.getSessionId();
    }

    protected SubscriptionOutput getOut() {
        return this.context.getOut();
    }

    protected void switchState(State newState) {
        this.context.switchState(newState);
    }

    protected boolean isConnectionReady() {
        return this.context.isConnectionReady();
    }

    public void scheduleTask(Runnable task, long timeout, TimeUnit unit) {
        this.context.scheduleTask(this.linkTaskToState(task), timeout, unit);
    }

    public void addTask(Runnable task) {
        this.context.addTask(this.linkTaskToState(task));
    }

    private Runnable linkTaskToState(Runnable task) {
        return () -> {
            if (!this.isCurrent()) {
                return;
            }
            task.run();
        };
    }

    protected void registerSession() {
        this.context.registerSession();
    }

    protected void unregisterSession() {
        this.context.unregisterSession();
    }
}

