/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadi.repository.zookeeper.ZooKeeperHolder;
import org.zalando.nakadi.util.FeatureToggleService;

public class FeatureToggleServiceZk
implements FeatureToggleService {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureToggleService.class);
    private static final String PREFIX = "/nakadi/feature_toggle/";
    private final ZooKeeperHolder zkHolder;
    private final LoadingCache<FeatureToggleService.Feature, Boolean> cache;

    public FeatureToggleServiceZk(ZooKeeperHolder zkHolder) {
        this.zkHolder = zkHolder;
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<FeatureToggleService.Feature, Boolean>(){

            public Boolean load(FeatureToggleService.Feature key) throws Exception {
                return FeatureToggleServiceZk.this.isFeatureEnabledInZk(key);
            }
        });
    }

    @Override
    public boolean isFeatureEnabled(FeatureToggleService.Feature feature) {
        try {
            return (Boolean)this.cache.get((Object)feature);
        }
        catch (ExecutionException e) {
            LOG.warn("Error occurred when checking if feature '" + feature.getId() + "' is toggled", (Throwable)e);
            return false;
        }
    }

    private Boolean isFeatureEnabledInZk(FeatureToggleService.Feature feature) throws Exception {
        return null != this.zkHolder.get().checkExists().forPath(PREFIX + feature.getId());
    }
}

