/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.ThrowableProblem;

public class GzipBodyRequestFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GzipBodyRequestFilter.class);
    private final ObjectMapper objectMapper;

    public GzipBodyRequestFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Object request = (HttpServletRequest)servletRequest;
        boolean isGzipped = Optional.ofNullable(request.getHeader("Content-Encoding")).map(encoding -> encoding.contains("gzip")).orElse(false);
        if (isGzipped && !"POST".equals(request.getMethod())) {
            this.reportNotAcceptableError((HttpServletResponse)servletResponse, (HttpServletRequest)request);
            return;
        }
        if (isGzipped) {
            request = new GzipServletRequestWrapper((HttpServletRequest)request);
        }
        chain.doFilter((ServletRequest)request, servletResponse);
    }

    private void reportNotAcceptableError(HttpServletResponse response, HttpServletRequest request) throws IOException {
        response.setStatus(Response.Status.NOT_ACCEPTABLE.getStatusCode());
        PrintWriter writer = response.getWriter();
        ThrowableProblem problem = Problem.valueOf((Response.StatusType)Response.Status.NOT_ACCEPTABLE, (String)(request.getMethod() + " method doesn't support gzip content encoding"));
        writer.write(this.objectMapper.writeValueAsString((Object)problem));
        writer.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private class GzipServletInputStream
    extends ServletInputStream {
        private final InputStream inputStream;

        public GzipServletInputStream(InputStream inputStream) throws IOException {
            this.inputStream = new GZIPInputStream(inputStream);
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public boolean isFinished() {
            try {
                return this.inputStream.available() == 0;
            }
            catch (IOException e) {
                LOG.error("Error occurred when reading request input stream", (Throwable)e);
                return false;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private class GzipServletRequestWrapper
    extends HttpServletRequestWrapper {
        public GzipServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public ServletInputStream getInputStream() throws IOException {
            return new GzipServletInputStream((InputStream)super.getInputStream());
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
    }
}

