/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.json.JSONObject;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.ValidationStrategyConfiguration;
import org.zalando.nakadi.validation.EventValidator;
import org.zalando.nakadi.validation.ValidationError;
import org.zalando.nakadi.validation.ValidationStrategy;

public class EventTypeValidator {
    private final EventType eventType;
    private final List<EventValidator> validators = Lists.newArrayList();

    public EventTypeValidator(EventType eventType) {
        this.eventType = eventType;
    }

    public Optional<ValidationError> validate(JSONObject event) {
        return this.validators.stream().map(validator -> validator.accepts(event)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public EventTypeValidator withConfiguration(ValidationStrategyConfiguration vsc) {
        ValidationStrategy vs = ValidationStrategy.lookup(vsc.getStrategyName());
        this.validators.add(vs.materialize(this.eventType, vsc));
        return this;
    }
}

