/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.contrib.spring.web.webfilter.WebFluxSpanDecorator;
import java.util.Arrays;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.web.server.ServerWebExchange;

@API(status=API.Status.EXPERIMENTAL)
public final class CompositeSpanDecorator
implements WebFluxSpanDecorator {
    private final Iterable<WebFluxSpanDecorator> decorators;

    public void onRequest(ServerWebExchange exchange, Span span) {
        this.decorators.forEach(decorator -> decorator.onRequest(exchange, span));
    }

    public void onResponse(ServerWebExchange exchange, Span span) {
        this.decorators.forEach(decorator -> decorator.onResponse(exchange, span));
    }

    public void onError(ServerWebExchange exchange, Throwable error, Span span) {
        this.decorators.forEach(decorator -> decorator.onError(exchange, error, span));
    }

    static WebFluxSpanDecorator composite(WebFluxSpanDecorator ... decorators) {
        return CompositeSpanDecorator.composite(Arrays.asList(decorators));
    }

    static WebFluxSpanDecorator composite(Iterable<WebFluxSpanDecorator> decorators) {
        return new CompositeSpanDecorator(decorators);
    }

    @Generated
    public CompositeSpanDecorator(Iterable<WebFluxSpanDecorator> decorators) {
        this.decorators = decorators;
    }
}

