/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.function.Predicate;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class ErrorSpanDecorator
implements SpanDecorator {
    private final Predicate<HttpStatus> predicate;

    public ErrorSpanDecorator() {
        this(HttpStatus::is5xxServerError);
    }

    @Override
    public void onResponse(ServerWebExchange exchange, Span span) {
        HttpStatus statusCode = exchange.getResponse().getStatusCode();
        if (statusCode == null || this.predicate.test(statusCode)) {
            span.setTag((Tag)Tags.ERROR, (Object)true);
        }
    }

    @Override
    public void onError(ServerWebExchange exchange, Throwable error, Span span) {
        span.setTag((Tag)Tags.ERROR, (Object)true);
        HashMap<String, Object> fields = new HashMap<String, Object>(2);
        fields.put("error.kind", error.getClass().getSimpleName());
        fields.put("error.object", error);
        span.log(fields);
    }

    @Generated
    public ErrorSpanDecorator(Predicate<HttpStatus> predicate) {
        this.predicate = predicate;
    }
}

