/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import org.apiguardian.api.API;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class ErrorStackSpanDecorator
implements SpanDecorator {
    @Override
    public void onError(ServerWebExchange exchange, Throwable error, Span span) {
        span.log(Collections.singletonMap("stack", this.toString(error)));
    }

    private String toString(Throwable error) {
        StringWriter output = new StringWriter(2048);
        error.printStackTrace(new PrintWriter(output));
        return output.toString();
    }
}

