/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.util.Objects;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpMethodOverrideSpanDecorator
implements SpanDecorator {
    private static final Tag<String> HTTP_METHOD_OVERRIDE = new StringTag("http.method_override");

    @Override
    public void onRequest(ServerWebExchange exchange, Span span) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        Stream.of("HTTP-Method-Override", "X-HTTP-Method-Override").map(arg_0 -> ((HttpHeaders)headers).getFirst(arg_0)).filter(Objects::nonNull).findFirst().ifPresent(override -> span.setTag(HTTP_METHOD_OVERRIDE, override));
    }
}

