/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpPathSpanDecorator
implements SpanDecorator {
    private static final Tag<String> HTTP_PATH = new StringTag("http.path");

    @Override
    public void onResponse(ServerWebExchange exchange, Span span) {
        this.tag(exchange, span);
    }

    @Override
    public void onError(ServerWebExchange exchange, Throwable error, Span span) {
        this.tag(exchange, span);
    }

    private void tag(ServerWebExchange exchange, Span span) {
        Stream<Function> stream = Stream.of(this::getPath, this::getPattern);
        stream.map(function -> (Optional)function.apply(exchange)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(path -> span.setTag(HTTP_PATH, path));
    }

    private Optional<String> getPath(ServerWebExchange exchange) {
        return Optional.ofNullable(exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE)).filter(HandlerMethod.class::isInstance).map(HandlerMethod.class::cast).map(method -> (RequestMapping)method.getMethodAnnotation(RequestMapping.class)).map(RequestMapping::path).map(Arrays::asList).map(List::iterator).filter(Iterator::hasNext).map(Iterator::next);
    }

    private Optional<String> getPattern(ServerWebExchange exchange) {
        return Optional.ofNullable(exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)).map(Object::toString);
    }
}

