/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpPreferSpanDecorator
implements SpanDecorator {
    private static final Tag<String> PREFER = new StringTag("http.prefer");

    @Override
    public void onRequest(ServerWebExchange exchange, Span span) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        Optional.ofNullable(headers.getFirst("Prefer")).ifPresent(prefer -> span.setTag(PREFER, prefer));
    }
}

