/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpRetryAfterSpanDecorator
implements SpanDecorator {
    private static final Tag<String> RETRY_AFTER = new StringTag("http.retry_after");

    @Override
    public void onResponse(ServerWebExchange exchange, Span span) {
        ServerHttpResponse response = exchange.getResponse();
        HttpHeaders headers = response.getHeaders();
        Optional.ofNullable(headers.getFirst("Retry-After")).ifPresent(prefer -> span.setTag(RETRY_AFTER, prefer));
    }
}

