/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpStatusCodeSpanDecorator
implements SpanDecorator {
    @Override
    public void onResponse(ServerWebExchange exchange, Span span) {
        ServerHttpResponse response = exchange.getResponse();
        Optional.ofNullable(response.getStatusCode()).ifPresent(status -> span.setTag((Tag)Tags.HTTP_STATUS, (Object)status.value()));
    }
}

