/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.spring.webflux.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.opentracing.spring.webflux.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class PeerSpanDecorator
implements SpanDecorator {
    @API(status=API.Status.EXPERIMENTAL)
    public static final Tag<String> PEER_ADDRESS = new StringTag("peer.address");
    @API(status=API.Status.INTERNAL)
    private static final Tag<String> PEER_HOST_IPV4 = new StringTag("peer.ipv4");

    @Override
    public void onRequest(ServerWebExchange exchange, Span span) {
        ServerHttpRequest request = exchange.getRequest();
        Optional.ofNullable(request.getRemoteAddress()).ifPresent(address -> {
            String hostname = address.getHostString();
            int port = address.getPort();
            span.setTag(PEER_ADDRESS, (Object)(hostname + ":" + port));
            span.setTag((Tag)Tags.PEER_PORT, (Object)port);
            InetAddress ip = address.getAddress();
            if (ip == null) {
                span.setTag((Tag)Tags.PEER_HOSTNAME, (Object)hostname);
            } else {
                if (!hostname.equals(ip.getHostAddress())) {
                    span.setTag((Tag)Tags.PEER_HOSTNAME, (Object)hostname);
                }
                this.tagIfMatch(span, Inet4Address.class, PEER_HOST_IPV4, ip);
                this.tagIfMatch(span, Inet6Address.class, (Tag<String>)Tags.PEER_HOST_IPV6, ip);
            }
        });
    }

    private void tagIfMatch(Span span, Class<? extends InetAddress> type, Tag<String> tag, InetAddress address) {
        if (type.isInstance(address)) {
            span.setTag(tag, (Object)address.getHostAddress());
        }
    }
}

