/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.sqs;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public final class SQSTracing {
    private static final String SPAN_CONTEXT_ATTRIBUTE_KEY = "span_ctx";
    private static final String STRING_DATA_TYPE = "String";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Tracer tracer;
    private final String attributeKey;

    public SQSTracing(Tracer tracer) {
        this(tracer, SPAN_CONTEXT_ATTRIBUTE_KEY);
    }

    public SQSTracing(Tracer tracer, String attributeKey) {
        this.tracer = tracer;
        this.attributeKey = attributeKey;
    }

    public com.amazonaws.services.sqs.model.SendMessageRequest injectInto(com.amazonaws.services.sqs.model.SendMessageRequest request) {
        return this.injectInto(request, (SpanContext)this.activeContext().orElse(null));
    }

    public com.amazonaws.services.sqs.model.SendMessageRequest injectInto(com.amazonaws.services.sqs.model.SendMessageRequest request, SpanContext spanContext) {
        if (spanContext != null) {
            HashMap<String, String> contextMap = new HashMap<String, String>();
            this.tracer.inject(spanContext, Format.Builtin.TEXT_MAP_INJECT, (Object)new TextMapInjectAdapter(contextMap));
            request.addMessageAttributesEntry(this.attributeKey, new com.amazonaws.services.sqs.model.MessageAttributeValue().withDataType(STRING_DATA_TYPE).withStringValue(this.jsonEncode(contextMap)));
        }
        return request;
    }

    public SendMessageBatchRequestEntry injectInto(SendMessageBatchRequestEntry request, SpanContext spanContext) {
        if (spanContext != null) {
            HashMap<String, String> contextMap = new HashMap<String, String>();
            this.tracer.inject(spanContext, Format.Builtin.TEXT_MAP_INJECT, (Object)new TextMapInjectAdapter(contextMap));
            request.addMessageAttributesEntry(this.attributeKey, new com.amazonaws.services.sqs.model.MessageAttributeValue().withDataType(STRING_DATA_TYPE).withStringValue(this.jsonEncode(contextMap)));
        }
        return request;
    }

    public SendMessageBatchRequest injectInto(SendMessageBatchRequest request) {
        return this.injectInto(request, (SpanContext)this.activeContext().orElse(null));
    }

    public SendMessageBatchRequest injectInto(SendMessageBatchRequest request, SpanContext spanContext) {
        if (spanContext != null) {
            HashMap contextMap = new HashMap();
            this.tracer.inject(spanContext, Format.Builtin.TEXT_MAP_INJECT, (Object)new TextMapInjectAdapter(contextMap));
            request.getEntries().forEach(entry -> entry.addMessageAttributesEntry(this.attributeKey, new com.amazonaws.services.sqs.model.MessageAttributeValue().withDataType(STRING_DATA_TYPE).withStringValue(this.jsonEncode(contextMap))));
        }
        return request;
    }

    public SendMessageRequest injectInto(SendMessageRequest request) {
        return this.injectInto(request, (SpanContext)this.activeContext().orElse(null));
    }

    public SendMessageRequest injectInto(SendMessageRequest request, SpanContext spanContext) {
        if (spanContext == null) {
            return request;
        }
        return (SendMessageRequest)request.toBuilder().messageAttributes(this.tracedAttributes(request.messageAttributes(), spanContext)).build();
    }

    public software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry injectInto(software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry request, SpanContext spanContext) {
        if (spanContext == null) {
            return request;
        }
        return (software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry)request.toBuilder().messageAttributes(this.tracedAttributes(request.messageAttributes(), spanContext)).build();
    }

    public software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest injectInto(software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest request) {
        return this.injectInto(request, (SpanContext)this.activeContext().orElse(null));
    }

    public software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest injectInto(software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest request, SpanContext spanContext) {
        if (spanContext == null) {
            return request;
        }
        List tracedEntries = request.entries().stream().map(entry -> this.injectInto((software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry)entry, spanContext)).collect(Collectors.toList());
        return (software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest)request.toBuilder().entries(tracedEntries).build();
    }

    public Map<String, SpanContext> extractFrom(ReceiveMessageResult result) {
        return SQSTracing.flattenMap(result.getMessages().stream().collect(Collectors.toMap(Message::getMessageId, msg -> Optional.ofNullable((com.amazonaws.services.sqs.model.MessageAttributeValue)msg.getMessageAttributes().get(this.attributeKey)).flatMap(json -> this.jsonDecode(json.getStringValue())).flatMap(this::safeExtract))));
    }

    public Map<String, SpanContext> extractFrom(ReceiveMessageResponse response) {
        return SQSTracing.flattenMap(response.messages().stream().collect(Collectors.toMap(software.amazon.awssdk.services.sqs.model.Message::messageId, msg -> Optional.ofNullable((MessageAttributeValue)msg.messageAttributes().get(this.attributeKey)).flatMap(json -> this.jsonDecode(json.stringValue())).flatMap(this::safeExtract))));
    }

    public Span createActiveQueueingSpan(String queueUrl, String spanName) {
        return this.createQueueingSpan(queueUrl, spanName, true);
    }

    public Span createQueueingSpan(String queueUrl, String spanName, boolean activate) {
        Tracer.SpanBuilder builder = this.tracer.buildSpan(spanName).withTag(Tags.SPAN_KIND.getKey(), "producer").withTag(Tags.MESSAGE_BUS_DESTINATION.getKey(), queueUrl);
        Optional.ofNullable(this.tracer.activeSpan()).ifPresent(span -> builder.addReference("follows_from", span.context()));
        Span span2 = builder.start();
        if (activate) {
            this.tracer.scopeManager().activate(span2);
        }
        return span2;
    }

    private Optional<SpanContext> safeExtract(Map<String, String> contextMap) {
        try {
            return Optional.ofNullable(this.tracer.extract(Format.Builtin.TEXT_MAP_EXTRACT, (Object)new TextMapExtractAdapter(contextMap)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private Optional<SpanContext> activeContext() {
        return Optional.ofNullable(this.tracer.activeSpan()).map(Span::context);
    }

    private static <T> Map<String, T> flattenMap(Map<String, Optional<T>> mapWithOptionals) {
        HashMap flattened = new HashMap();
        mapWithOptionals.forEach((k, v) -> v.ifPresent(t -> flattened.put(k, t)));
        return flattened;
    }

    private Map<String, MessageAttributeValue> tracedAttributes(Map<String, MessageAttributeValue> attributes, SpanContext spanContext) {
        HashMap<String, MessageAttributeValue> tracedAttributes = new HashMap<String, MessageAttributeValue>(attributes);
        HashMap<String, String> contextMap = new HashMap<String, String>();
        this.tracer.inject(spanContext, Format.Builtin.TEXT_MAP_INJECT, (Object)new TextMapInjectAdapter(contextMap));
        tracedAttributes.put(this.attributeKey, (MessageAttributeValue)MessageAttributeValue.builder().dataType(STRING_DATA_TYPE).stringValue(this.jsonEncode(contextMap)).build());
        return tracedAttributes;
    }

    private Optional<Map<String, String>> jsonDecode(String json) {
        try {
            return Optional.of((Map)MAPPER.readValue(json, (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private String jsonEncode(Map<String, String> map) {
        try {
            return MAPPER.writer().writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            return "{}";
        }
    }
}

