/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import org.zalando.problem.AbstractThrowableProblem;
import org.zalando.problem.URITypeAdapter;

final class CustomProblemAdapter<T>
extends TypeAdapter<T> {
    private final Gson gson;
    private final TypeAdapter<T> delegate;
    private final boolean stackTraces;

    public void write(JsonWriter out, T value) throws IOException {
        JsonElement element = this.delegate.toJsonTree(value);
        JsonObject object = element.getAsJsonObject();
        URI problemType = (URI)URITypeAdapter.TYPE.fromJsonTree(object.remove("type"));
        object.add("type", URITypeAdapter.TYPE.toJsonTree((Object)problemType));
        if (value instanceof AbstractThrowableProblem) {
            this.flattenParameters(object);
        }
        if (value instanceof Throwable) {
            object.remove("detailMessage");
            object.remove("suppressedExceptions");
            object.remove("stackTrace");
            if (this.stackTraces) {
                object.add("stacktrace", this.gson.getAdapter(String[].class).toJsonTree(Arrays.stream(((Throwable)value).getStackTrace()).map(Object::toString).toArray(String[]::new)));
            }
        }
        Streams.write((JsonElement)element, (JsonWriter)out);
    }

    private void flattenParameters(JsonObject object) {
        Optional.ofNullable(object.remove("parameters")).map(JsonElement::getAsJsonObject).ifPresent(params -> params.entrySet().forEach(e -> object.add((String)e.getKey(), (JsonElement)e.getValue())));
    }

    public T read(JsonReader in) throws IOException {
        return (T)this.delegate.read(in);
    }

    public CustomProblemAdapter(Gson gson, TypeAdapter<T> delegate, boolean stackTraces) {
        this.gson = gson;
        this.delegate = delegate;
        this.stackTraces = stackTraces;
    }
}

