/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.URITypeAdapter;

final class DefaultProblemAdapter
extends TypeAdapter<ThrowableProblem> {
    private final Gson gson;
    private final boolean stackTraces;
    private final TypeAdapter<URI> type = URITypeAdapter.TYPE;
    private final TypeAdapter<Map<String, Object>> parameters;
    private final TypeAdapter<StatusType> status;
    private final TypeAdapter<ThrowableProblem> cause;

    DefaultProblemAdapter(Gson gson, boolean stackTraces) {
        this(gson, stackTraces, (TypeAdapter<Map<String, Object>>)gson.getAdapter((TypeToken)new TypeToken<Map<String, Object>>(){}), (TypeAdapter<StatusType>)gson.getAdapter(StatusType.class), (TypeAdapter<ThrowableProblem>)gson.getAdapter(ThrowableProblem.class).nullSafe());
    }

    public void write(JsonWriter out, ThrowableProblem problem) throws IOException {
        JsonObject object = new JsonObject();
        object.add("type", this.type.toJsonTree((Object)problem.getType()));
        object.add("title", TypeAdapters.STRING.toJsonTree((Object)problem.getTitle()));
        object.add("status", this.status.toJsonTree((Object)problem.getStatus()));
        object.add("detail", TypeAdapters.STRING.toJsonTree((Object)problem.getDetail()));
        object.add("instance", TypeAdapters.URI.toJsonTree((Object)problem.getInstance()));
        object.add("cause", this.cause.toJsonTree((Object)problem.getCause()));
        this.parameters.toJsonTree((Object)problem.getParameters()).getAsJsonObject().entrySet().forEach(entry -> object.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        if (this.stackTraces) {
            object.add("stacktrace", this.gson.getAdapter(String[].class).toJsonTree(Arrays.stream(problem.getStackTrace()).map(Object::toString).toArray(String[]::new)));
        }
        this.gson.getAdapter(JsonElement.class).write(out, (Object)object);
    }

    public ThrowableProblem read(JsonReader in) throws IOException {
        ProblemBuilder builder = new ProblemBuilder();
        in.beginObject();
        block16: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "type": {
                    builder.withType((URI)URITypeAdapter.TYPE.read(in));
                    continue block16;
                }
                case "title": {
                    builder.withTitle((String)TypeAdapters.STRING.read(in));
                    continue block16;
                }
                case "status": {
                    builder.withStatus((StatusType)this.status.read(in));
                    continue block16;
                }
                case "detail": {
                    builder.withDetail((String)TypeAdapters.STRING.read(in));
                    continue block16;
                }
                case "instance": {
                    builder.withInstance((URI)TypeAdapters.URI.read(in));
                    continue block16;
                }
                case "cause": {
                    builder.withCause((ThrowableProblem)this.cause.read(in));
                    continue block16;
                }
            }
            builder.with(name, this.gson.fromJson(in, Object.class));
        }
        in.endObject();
        return builder.build();
    }

    private DefaultProblemAdapter(Gson gson, boolean stackTraces, TypeAdapter<Map<String, Object>> parameters, TypeAdapter<StatusType> status, TypeAdapter<ThrowableProblem> cause) {
        this.gson = gson;
        this.stackTraces = stackTraces;
        this.parameters = parameters;
        this.status = status;
        this.cause = cause;
    }
}

