/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.gson.CustomProblemAdapter;
import org.zalando.problem.gson.DefaultProblemAdapter;
import org.zalando.problem.gson.StatusTypeAdapter;
import org.zalando.problem.gson.URITypeAdapter;

@API(status=API.Status.EXPERIMENTAL)
public final class ProblemAdapterFactory
implements TypeAdapterFactory {
    private final boolean stackTraces;
    private final Map<URI, TypeToken<? extends Problem>> subtypes;
    private final StatusTypeAdapter statusAdapter;

    public ProblemAdapterFactory() {
        this(Status.class);
    }

    @SafeVarargs
    public <E extends Enum<?>> ProblemAdapterFactory(Class<? extends E> ... statusTypes) {
        this(false, new StatusTypeAdapter(ProblemAdapterFactory.buildIndex(statusTypes)), Collections.emptyMap());
    }

    private ProblemAdapterFactory(boolean stackTraces, StatusTypeAdapter statusAdapter, Map<URI, TypeToken<? extends Problem>> subtypes) {
        this.stackTraces = stackTraces;
        this.statusAdapter = statusAdapter;
        this.subtypes = Collections.unmodifiableMap(subtypes);
    }

    @SafeVarargs
    private static <E extends Enum<?>> Map<Integer, StatusType> buildIndex(Class<? extends E> ... types) {
        HashMap<Integer, Enum> index = new HashMap<Integer, Enum>();
        for (Class<E> clazz : types) {
            for (Enum status : (Enum[])clazz.getEnumConstants()) {
                if (index.containsKey(((StatusType)status).getStatusCode())) {
                    throw new IllegalArgumentException("Duplicate status codes are not allowed");
                }
                index.put(((StatusType)status).getStatusCode(), status);
            }
        }
        return Collections.unmodifiableMap(index);
    }

    public ProblemAdapterFactory withStackTraces() {
        return this.withStackTraces(true);
    }

    public ProblemAdapterFactory withStackTraces(boolean stackTraces) {
        return new ProblemAdapterFactory(stackTraces, this.statusAdapter, this.subtypes);
    }

    public ProblemAdapterFactory registerSubtype(URI uri, Class<? extends Problem> type) {
        return this.registerSubType(uri, (TypeToken<? extends Problem>)TypeToken.get(type));
    }

    public ProblemAdapterFactory registerSubType(URI uri, TypeToken<? extends Problem> type) {
        Objects.requireNonNull(type, "Type");
        Objects.requireNonNull(uri, "URI");
        if (this.subtypes.containsKey(uri)) {
            throw new IllegalArgumentException("class & type must be unique");
        }
        HashMap<URI, TypeToken<? extends Problem>> map = new HashMap<URI, TypeToken<? extends Problem>>(this.subtypes);
        map.put(uri, type);
        return new ProblemAdapterFactory(this.stackTraces, this.statusAdapter, map);
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (StatusType.class.isAssignableFrom(rawType)) {
            return this.statusAdapter;
        }
        if (!Problem.class.isAssignableFrom(rawType)) {
            return null;
        }
        return new ProblemTypeAdapter<T>(gson, type).nullSafe();
    }

    private final class ProblemTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Gson gson;
        private final TypeToken<T> type;
        private final TypeAdapter<ThrowableProblem> defaultAdapter;

        ProblemTypeAdapter(Gson gson, TypeToken<T> type) {
            this(gson, type, new DefaultProblemAdapter(gson, problemAdapterFactory.stackTraces));
        }

        public void write(JsonWriter out, T value) throws IOException {
            TypeAdapter<T> adapter = this.selectAdapter(value);
            adapter.write(out, value);
        }

        private TypeAdapter<T> selectAdapter(T value) {
            if (value instanceof DefaultProblem) {
                return this.defaultAdapter;
            }
            Class<?> valueType = value.getClass();
            return this.createCustomAdapter(this.gson, TypeToken.get(valueType));
        }

        public T read(JsonReader in) {
            JsonElement element = Streams.parse((JsonReader)in);
            JsonObject problem = element.getAsJsonObject();
            return (T)this.selectAdapter(problem).fromJsonTree(element);
        }

        private TypeAdapter<T> selectAdapter(JsonObject problem) {
            @Nullable TypeToken<T> subType = Optional.ofNullable(problem.get("type")).map(arg_0 -> URITypeAdapter.TYPE.fromJsonTree(arg_0)).map(ProblemAdapterFactory.this.subtypes::get).orElse(null);
            if (subType == null) {
                return this.defaultAdapter;
            }
            TypeToken<T> typeClass = this.type.getRawType().isAssignableFrom(subType.getRawType()) ? subType : this.type;
            return this.createCustomAdapter(this.gson, typeClass);
        }

        private TypeAdapter<T> createCustomAdapter(Gson gson, TypeToken<T> type) {
            return new CustomProblemAdapter(gson, gson.getDelegateAdapter((TypeAdapterFactory)ProblemAdapterFactory.this, type), ProblemAdapterFactory.this.stackTraces);
        }

        private ProblemTypeAdapter(Gson gson, TypeToken<T> type, TypeAdapter<ThrowableProblem> defaultAdapter) {
            this.gson = gson;
            this.type = type;
            this.defaultAdapter = defaultAdapter;
        }
    }
}

