/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.autoconfigure.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.ClassUtils;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

public class ProblemSecurityBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ProblemSecurityBeanPostProcessor.class);
    private final ObjectProvider<SecurityProblemSupport> securityProblemSupport;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ClassUtils.isAssignableValue(HttpSecurity.class, (Object)bean)) {
            this.securityProblemSupport.ifAvailable(support -> this.register((HttpSecurity)bean, beanName, (SecurityProblemSupport)support));
        }
        return bean;
    }

    private void register(HttpSecurity http, String beanName, SecurityProblemSupport support) {
        try {
            http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)support).accessDeniedHandler((AccessDeniedHandler)support);
        }
        catch (Exception cause) {
            throw new BeanCreationException(beanName, (Throwable)cause);
        }
        log.info("Register HttpSecurity's exceptionHandling");
    }

    public ProblemSecurityBeanPostProcessor(ObjectProvider<SecurityProblemSupport> securityProblemSupport) {
        this.securityProblemSupport = securityProblemSupport;
    }
}

