/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.Lists;
import org.zalando.problem.spring.web.advice.MediaTypes;

public interface AdviceTrait {
    default public ResponseEntity<Problem> create(Response.StatusType status, Throwable throwable, NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        return this.create(status, throwable, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(Response.StatusType status, Throwable throwable, NativeWebRequest request, HttpHeaders headers) throws HttpMediaTypeNotAcceptableException {
        return this.create(throwable, (Problem)this.toProblem(throwable, status), request, headers);
    }

    default public ThrowableProblem toProblem(Throwable throwable, Response.StatusType status) {
        StackTraceElement[] stackTrace;
        Throwable cause = throwable.getCause();
        ProblemBuilder builder = Problem.builder().withType(URI.create("about:blank")).withTitle(status.getReasonPhrase()).withStatus(status).withDetail(throwable.getMessage());
        if (cause == null || !this.isCausalChainsEnabled()) {
            stackTrace = throwable.getStackTrace();
        } else {
            builder.withCause(this.toProblem(cause, status));
            StackTraceElement[] next = cause.getStackTrace();
            StackTraceElement[] current = throwable.getStackTrace();
            int length = current.length - Lists.lengthOfTrailingPartialSubList(Arrays.asList(next), Arrays.asList(current));
            stackTrace = new StackTraceElement[length];
            System.arraycopy(current, 0, stackTrace, 0, length);
        }
        ThrowableProblem problem = builder.build();
        problem.setStackTrace(stackTrace);
        return problem;
    }

    default public boolean isCausalChainsEnabled() {
        return false;
    }

    default public ResponseEntity<Problem> create(ThrowableProblem problem, NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        return this.create(problem, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(ThrowableProblem problem, NativeWebRequest request, HttpHeaders headers) throws HttpMediaTypeNotAcceptableException {
        return this.create((Throwable)problem, (Problem)problem, request, headers);
    }

    default public ResponseEntity<Problem> create(Throwable throwable, Problem problem, NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        return this.create(throwable, problem, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(Throwable throwable, Problem problem, NativeWebRequest request, HttpHeaders headers) throws HttpMediaTypeNotAcceptableException {
        if (problem.getStatus().getStatusCode() == 500) {
            request.setAttribute("javax.servlet.error.exception", (Object)throwable, 0);
        }
        return this.process((ResponseEntity<Problem>)this.negotiate(request).map(contentType -> {
            int statusCode = problem.getStatus().getStatusCode();
            HttpStatus status = HttpStatus.valueOf((int)statusCode);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).contentType(contentType).body((Object)problem);
        }).orElseGet(() -> ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).body(null)));
    }

    default public Optional<MediaType> negotiate(NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        HeaderContentNegotiationStrategy negotiator = new HeaderContentNegotiationStrategy();
        List mediaTypes = negotiator.resolveMediaTypes(request);
        if (mediaTypes.isEmpty()) {
            return Optional.of(MediaTypes.PROBLEM);
        }
        for (MediaType mediaType : mediaTypes) {
            if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
                return Optional.of(MediaTypes.PROBLEM);
            }
            if (MediaTypes.PROBLEM.isCompatibleWith(mediaType)) {
                return Optional.of(MediaTypes.PROBLEM);
            }
            if (MediaTypes.X_PROBLEM.isCompatibleWith(mediaType)) {
                return Optional.of(MediaTypes.X_PROBLEM);
            }
            if (!MediaTypes.WILDCARD_JSON.isCompatibleWith(mediaType)) continue;
            return Optional.of(MediaTypes.PROBLEM);
        }
        return Optional.empty();
    }

    default public ResponseEntity<Problem> process(ResponseEntity<Problem> entity) {
        return entity;
    }
}

