/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.validation.BaseValidationAdviceTrait;
import org.zalando.problem.spring.web.advice.validation.Violation;

public interface MethodArgumentNotValidAdviceTrait
extends BaseValidationAdviceTrait {
    default public Violation createViolation(FieldError error) {
        String fieldName = error.getObjectName() + "." + error.getField();
        return new Violation(this.formatFieldName(fieldName), error.getDefaultMessage());
    }

    default public Violation createViolation(ObjectError error) {
        String fieldName = this.formatFieldName(error.getObjectName());
        return new Violation(fieldName, error.getDefaultMessage());
    }

    @ExceptionHandler
    default public ResponseEntity<Problem> handleMethodArgumentNotValid(MethodArgumentNotValidException exception, NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        List<Violation> violations = Stream.concat(exception.getBindingResult().getFieldErrors().stream().map(this::createViolation), exception.getBindingResult().getGlobalErrors().stream().map(this::createViolation)).collect(Collectors.toList());
        return this.newConstraintViolationProblem((Throwable)exception, violations, request);
    }
}

