/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.core.Response;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.validation.Violation;

@JsonTypeName(value="https://zalando.github.io/problem/constraint-violation")
@Immutable
public final class ConstraintViolationProblem
extends ThrowableProblem {
    public static final String TYPE_VALUE = "https://zalando.github.io/problem/constraint-violation";
    public static final URI TYPE = URI.create("https://zalando.github.io/problem/constraint-violation");
    private final Response.StatusType status;
    private final String detail;
    private final List<Violation> violations;

    public ConstraintViolationProblem(Response.StatusType status, List<Violation> violations) {
        this(status, null, new ArrayList<Violation>(violations));
    }

    @JsonCreator
    ConstraintViolationProblem(Response.StatusType status, @Nullable String detail, List<Violation> violations) {
        this.status = status;
        this.detail = detail;
        this.violations = Collections.unmodifiableList(violations);
    }

    public URI getType() {
        return TYPE;
    }

    public String getTitle() {
        return "Constraint Violation";
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }
}

