/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.AdviceTrait;
import org.zalando.problem.spring.web.advice.validation.ConstraintViolationProblem;
import org.zalando.problem.spring.web.advice.validation.Violation;

interface BaseValidationAdviceTrait
extends AdviceTrait {
    default public Response.StatusType defaultConstraintViolationStatus() {
        return Response.Status.BAD_REQUEST;
    }

    default public String formatFieldName(String fieldName) {
        return fieldName;
    }

    default public ResponseEntity<Problem> newConstraintViolationProblem(Throwable throwable, Collection<Violation> stream, NativeWebRequest request) {
        Response.StatusType status = this.defaultConstraintViolationStatus();
        List<Violation> violations = stream.stream().sorted(Comparator.comparing(Violation::getField).thenComparing(Violation::getMessage)).collect(Collectors.toList());
        return this.create(throwable, (Problem)new ConstraintViolationProblem(status, violations), request);
    }
}

