/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice;

import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

final class MediaTypes {
    static final String PROBLEM_VALUE = "application/problem+json";
    static final MediaType PROBLEM = MediaType.parseMediaType((String)"application/problem+json");
    static final String X_PROBLEM_VALUE = "application/x.problem+json";
    static final MediaType X_PROBLEM = MediaType.parseMediaType((String)"application/x.problem+json");
    static final String WILDCARD_JSON_VALUE = "application/*+json";
    static final MediaType WILDCARD_JSON = MediaType.parseMediaType((String)"application/*+json");
    private static final Logger LOG = LoggerFactory.getLogger(MediaTypes.class);
    private static final HeaderContentNegotiationStrategy headerNegotiator = new HeaderContentNegotiationStrategy();

    MediaTypes() {
    }

    static Optional<MediaType> determineContentType(NativeWebRequest request) {
        try {
            List acceptedMediaTypes = headerNegotiator.resolveMediaTypes(request);
            if (acceptedMediaTypes.isEmpty()) {
                return Optional.of(PROBLEM);
            }
            if (acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)PROBLEM).isCompatibleWith(arg_0))) {
                return Optional.of(PROBLEM);
            }
            if (acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)X_PROBLEM).isCompatibleWith(arg_0))) {
                return Optional.of(X_PROBLEM);
            }
            if (acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)WILDCARD_JSON).isCompatibleWith(arg_0))) {
                return Optional.of(PROBLEM);
            }
            if (acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.APPLICATION_JSON).isCompatibleWith(arg_0))) {
                return Optional.of(PROBLEM);
            }
        }
        catch (HttpMediaTypeNotAcceptableException exception) {
            LOG.info("Unable to determine content type due to error during parsing Accept header: [{}]", (Throwable)exception);
        }
        return Optional.empty();
    }
}

