/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.MediaTypes;

public final class Responses {
    Responses() {
    }

    public static ResponseEntity<Problem> create(Response.StatusType status, Throwable throwable, NativeWebRequest request, Function<ResponseEntity.BodyBuilder, ResponseEntity.BodyBuilder> buildable) {
        return Responses.create(status, throwable.getMessage(), request, buildable);
    }

    public static ResponseEntity<Problem> create(Response.StatusType status, Throwable throwable, NativeWebRequest request) {
        return Responses.create(status, throwable, request, Function.identity());
    }

    public static ResponseEntity<Problem> create(Response.StatusType status, String message, NativeWebRequest request, Function<ResponseEntity.BodyBuilder, ResponseEntity.BodyBuilder> buildable) {
        return Responses.create(Problem.valueOf((Response.StatusType)status, (String)message), request, buildable);
    }

    public static ResponseEntity<Problem> create(Response.StatusType status, String message, NativeWebRequest request) {
        return Responses.create(status, message, request, Function.identity());
    }

    public static ResponseEntity<Problem> create(Problem problem, NativeWebRequest request, Function<ResponseEntity.BodyBuilder, ResponseEntity.BodyBuilder> buildable) {
        HttpStatus status = Responses.map(problem.getStatus());
        ResponseEntity.BodyBuilder builder = buildable.apply(ResponseEntity.status((HttpStatus)status));
        Optional<MediaType> contentType = MediaTypes.determineContentType(request);
        if (contentType.isPresent()) {
            return builder.contentType(contentType.get()).body((Object)problem);
        }
        return builder.body(null);
    }

    public static ResponseEntity<Problem> create(Problem problem, NativeWebRequest request) {
        return Responses.create(problem, request, Function.identity());
    }

    @VisibleForTesting
    static HttpStatus map(Response.StatusType status) {
        return HttpStatus.valueOf((int)status.getStatusCode());
    }
}

