/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.springmvc.InvalidRequestException;
import com.atlassian.oai.validator.springmvc.InvalidResponseException;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.validation.BaseValidationAdviceTrait;
import org.zalando.problem.violations.Violation;

@API(status=API.Status.EXPERIMENTAL)
public interface OpenApiValidationAdviceTrait
extends BaseValidationAdviceTrait {
    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public ResponseEntity<Problem> handleInvalidRequest(InvalidRequestException exception, NativeWebRequest request) {
        return this.newConstraintViolationProblem((Exception)exception, request, exception.getValidationReport());
    }

    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public ResponseEntity<Problem> handleInvalidResponse(InvalidResponseException exception, NativeWebRequest request) {
        return this.newConstraintViolationProblem((Exception)exception, request, exception.getValidationReport());
    }

    default public ResponseEntity<Problem> newConstraintViolationProblem(Exception exception, NativeWebRequest request, ValidationReport report) {
        List<Violation> violations = report.getMessages().stream().map(this::createViolation).collect(Collectors.toList());
        return this.newConstraintViolationProblem((Throwable)exception, violations, request);
    }

    default public Violation createViolation(ValidationReport.Message message) {
        return new Violation(message.getKey(), message.getMessage());
    }
}

