/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.zalando.problem.MoreStatus;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.validation.Violation;

@JsonTypeName(value="https://github.com/zalando/problem/wiki/constraint-violation")
@Immutable
public final class ConstraintViolationProblem
extends ThrowableProblem {
    public static final String CONSTRAINT_VIOLATION_VALUE = "https://github.com/zalando/problem/wiki/constraint-violation";
    public static final URI CONSTRAINT_VIOLATION = URI.create("https://github.com/zalando/problem/wiki/constraint-violation");
    private final Optional<String> detail;
    private final ImmutableList<Violation> violations;

    public ConstraintViolationProblem(ImmutableList<Violation> violations) {
        this(Optional.empty(), violations);
    }

    @JsonCreator
    private ConstraintViolationProblem(Optional<String> detail, ImmutableList<Violation> violations) {
        this.detail = detail;
        this.violations = violations;
    }

    public URI getType() {
        return CONSTRAINT_VIOLATION;
    }

    public String getTitle() {
        return "Constraint Violation";
    }

    public MoreStatus getStatus() {
        return MoreStatus.UNPROCESSABLE_ENTITY;
    }

    public Optional<String> getDetail() {
        return this.detail;
    }

    public ImmutableList<Violation> getViolations() {
        return this.violations;
    }
}

