/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.webflux.advice;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.common.AdviceTraits;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE)
public interface AdviceTrait
extends org.zalando.problem.spring.common.AdviceTrait {
    default public Mono<ResponseEntity<Problem>> create(Throwable throwable, ServerWebExchange request) {
        ThrowableProblem problem = this.toProblem(throwable);
        return this.create(throwable, (Problem)problem, request);
    }

    default public Mono<ResponseEntity<Problem>> create(StatusType status, Throwable throwable, ServerWebExchange request) {
        return this.create(status, throwable, request, new HttpHeaders());
    }

    default public Mono<ResponseEntity<Problem>> create(StatusType status, Throwable throwable, ServerWebExchange request, HttpHeaders headers) {
        return this.create(throwable, (Problem)this.toProblem(throwable, status), request, headers);
    }

    default public Mono<ResponseEntity<Problem>> create(StatusType status, Throwable throwable, ServerWebExchange request, URI type) {
        return this.create(status, throwable, request, new HttpHeaders(), type);
    }

    default public Mono<ResponseEntity<Problem>> create(StatusType status, Throwable throwable, ServerWebExchange request, HttpHeaders headers, URI type) {
        return this.create(throwable, (Problem)this.toProblem(throwable, status, type), request, headers);
    }

    default public Mono<ResponseEntity<Problem>> create(ThrowableProblem problem, ServerWebExchange request) {
        return this.create(problem, request, new HttpHeaders());
    }

    default public Mono<ResponseEntity<Problem>> create(ThrowableProblem problem, ServerWebExchange request, HttpHeaders headers) {
        return this.create((Throwable)problem, (Problem)problem, request, headers);
    }

    default public Mono<ResponseEntity<Problem>> create(Throwable throwable, Problem problem, ServerWebExchange request) {
        return this.create(throwable, problem, request, new HttpHeaders());
    }

    default public Mono<ResponseEntity<Problem>> create(Throwable throwable, Problem problem, ServerWebExchange request, HttpHeaders headers) {
        HttpStatus status = HttpStatus.valueOf((int)Optional.ofNullable(problem.getStatus()).orElse((StatusType)Status.INTERNAL_SERVER_ERROR).getStatusCode());
        return this.log(throwable, problem, request, status).doOnSuccess(it -> {
            if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
                request.getAttributes().put("jakarta.servlet.error.exception", throwable);
            }
        }).then(Mono.justOrEmpty(this.negotiate(request))).map(contentType -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).headers(headers)).contentType(contentType).body((Object)problem)).switchIfEmpty(this.fallback(throwable, problem, request, headers)).flatMap(entity -> this.process((ResponseEntity<Problem>)entity, request));
    }

    default public Mono<Void> log(Throwable throwable, Problem problem, ServerWebExchange request, HttpStatus status) {
        return Mono.fromRunnable(() -> AdviceTraits.log((Throwable)throwable, (HttpStatus)status));
    }

    default public Optional<MediaType> negotiate(ServerWebExchange request) {
        List mediaTypes = new HeaderContentTypeResolver().resolveMediaTypes(request);
        return AdviceTraits.getProblemMediaType((List)mediaTypes);
    }

    default public Mono<ResponseEntity<Problem>> fallback(Throwable throwable, Problem problem, ServerWebExchange request, HttpHeaders headers) {
        return Mono.just((Object)AdviceTraits.fallback((Problem)problem, (HttpHeaders)headers));
    }

    default public Mono<ResponseEntity<Problem>> process(ResponseEntity<Problem> entity, ServerWebExchange request) {
        return Mono.just((Object)this.process(entity));
    }
}

