/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.webflux.advice.network;

import dev.failsafe.CircuitBreakerOpenException;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.webflux.advice.AdviceTrait;
import reactor.core.publisher.Mono;

@API(status=API.Status.EXPERIMENTAL)
public interface CircuitBreakerOpenAdviceTrait
extends AdviceTrait {
    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public Mono<ResponseEntity<Problem>> handleCircuitBreakerOpen(CircuitBreakerOpenException exception, ServerWebExchange request) {
        long delay = exception.getCircuitBreaker().getRemainingDelay().getSeconds();
        HttpHeaders headers = this.retryAfter(delay);
        return this.create((StatusType)Status.SERVICE_UNAVAILABLE, (Throwable)exception, request, headers);
    }

    default public HttpHeaders retryAfter(long delay) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Retry-After", String.valueOf(delay));
        return headers;
    }
}

