/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public enum MoreStatus implements Response.StatusType
{
    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    PROCESSING(102, "Processing"),
    CHECKPOINT(103, "Checkpoint"),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
    MULTI_STATUS(207, "Multi-Status"),
    ALREADY_REPORTED(208, "Already Reported"),
    IM_USED(226, "IM Used"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    PERMANENT_REDIRECT(308, "Permanent Redirect"),
    I_AM_A_TEAPOT(418, "I'm a teapot"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    LOCKED(423, "Locked"),
    FAILED_DEPENDENCY(424, "Failed Dependency"),
    UPGRADE_REQUIRED(426, "Upgrade Required"),
    PRECONDITION_REQUIRED(428, "Precondition Required"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
    VARIANT_ALSO_NEGOTIATES(506, "Variant Also Negotiates"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
    LOOP_DETECTED(508, "Loop Detected"),
    BANDWIDTH_LIMIT_EXCEEDED(509, "Bandwidth Limit Exceeded"),
    NOT_EXTENDED(510, "Not Extended"),
    NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required");

    private final int statusCode;
    private final Response.Status.Family family;
    private final String reasonPhrase;

    private MoreStatus(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.family = Response.Status.Family.familyOf((int)statusCode);
        this.reasonPhrase = reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response.Status.Family getFamily() {
        return this.family;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Nullable
    public static Response.StatusType fromStatusCode(int statusCode) {
        for (MoreStatus status : MoreStatus.values()) {
            if (status.getStatusCode() != statusCode) continue;
            return status;
        }
        return null;
    }
}

