/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.problem.Exceptional;
import org.zalando.problem.Problem;
import org.zalando.problem.spi.StackTraceProcessor;

@Immutable
public abstract class ThrowableProblem
extends RuntimeException
implements Problem,
Exceptional {
    public ThrowableProblem() {
        this((ThrowableProblem)null);
    }

    public ThrowableProblem(@Nullable ThrowableProblem cause) {
        super(cause);
        Collection<StackTraceElement> stackTrace = StackTraceProcessor.COMPOUND.process(Arrays.asList(this.getStackTrace()));
        this.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    @Override
    public String getMessage() {
        return Stream.of(this.getTitle(), this.getDetail()).filter(Objects::nonNull).collect(Collectors.joining(": "));
    }

    @Override
    public ThrowableProblem getCause() {
        return (ThrowableProblem)super.getCause();
    }

    @Override
    public String toString() {
        return Problem.toString(this);
    }
}

