/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import java.net.URI;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.core.Response;
import org.zalando.problem.GenericProblems;
import org.zalando.problem.ProblemBuilder;

@Immutable
public interface Problem {
    public URI getType();

    public String getTitle();

    public Response.StatusType getStatus();

    default public Optional<String> getDetail() {
        return Optional.empty();
    }

    default public Optional<URI> getInstance() {
        return Optional.empty();
    }

    public static ProblemBuilder builder() {
        return new ProblemBuilder();
    }

    public static Problem valueOf(Response.StatusType status) {
        return GenericProblems.create(status).build();
    }

    public static Problem valueOf(Response.StatusType status, String detail) {
        return GenericProblems.create(status).withDetail(detail).build();
    }
}

