/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.zalando.problem.DefaultProblem;

public final class ProblemBuilder {
    static final ImmutableSet<String> RESERVED_PROPERTIES = ImmutableSet.of((Object)"type", (Object)"title", (Object)"status", (Object)"detail", (Object)"instance");
    private URI type;
    private String title;
    private Response.StatusType status;
    private Optional<String> detail = Optional.empty();
    private Optional<URI> instance = Optional.empty();
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    ProblemBuilder() {
    }

    public ProblemBuilder withType(URI type) {
        this.type = type;
        return this;
    }

    public ProblemBuilder withTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public ProblemBuilder withStatus(@Nullable Response.StatusType status) {
        this.status = status;
        return this;
    }

    public ProblemBuilder withDetail(@Nullable String detail) {
        this.detail = Optional.ofNullable(detail);
        return this;
    }

    public ProblemBuilder withInstance(@Nullable URI instance) {
        this.instance = Optional.ofNullable(instance);
        return this;
    }

    public ProblemBuilder with(String key, Object value) throws IllegalArgumentException {
        if (RESERVED_PROPERTIES.contains((Object)key)) {
            throw new IllegalArgumentException("Property " + key + " is reserved");
        }
        this.parameters.put(key, value);
        return this;
    }

    public DefaultProblem build() {
        DefaultProblem problem = new DefaultProblem(this.type, this.title, this.status, this.detail, this.instance);
        this.parameters.forEach(problem::set);
        return problem;
    }
}

