/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.capture;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.zalando.riptide.capture.Capture;
import org.zalando.riptide.capture.CaptureException;

final class DefaultCapture<T>
implements Capture<T> {
    private final AtomicReference<Optional<T>> reference = new AtomicReference();

    DefaultCapture() {
    }

    @Override
    public void capture(@Nullable T result) {
        boolean captured = this.reference.compareAndSet(null, Optional.ofNullable(result));
        if (!captured) {
            throw new IllegalStateException("Already captured");
        }
    }

    @Override
    public T retrieve() {
        Optional<Object> value = this.reference.get();
        if (value == null) {
            throw new CaptureException();
        }
        return value.orElse(null);
    }
}

