/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.faults;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.function.Predicate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apiguardian.api.API;
import org.zalando.riptide.faults.ClassificationStrategy;
import org.zalando.riptide.faults.Predicates;
import org.zalando.riptide.faults.Rule;

@API(status=API.Status.EXPERIMENTAL)
public final class TransientFaults {
    private TransientFaults() {
    }

    public static Predicate<Throwable> transientSocketFaults() {
        return TransientFaults.transientSocketFaults(ClassificationStrategy.causalChain());
    }

    public static Predicate<Throwable> transientSocketFaults(ClassificationStrategy strategy) {
        return TransientFaults.combine(strategy, Rules.transientSocketFaultRules());
    }

    public static Predicate<Throwable> transientConnectionFaults() {
        return TransientFaults.transientConnectionFaults(ClassificationStrategy.causalChain());
    }

    public static Predicate<Throwable> transientConnectionFaults(ClassificationStrategy strategy) {
        return TransientFaults.combine(strategy, Rules.transientConnectionFaultRules());
    }

    public static Predicate<Throwable> combine(ClassificationStrategy strategy, Predicate<Throwable> predicate) {
        return throwable -> strategy.test((Throwable)throwable, predicate);
    }

    public static Predicate<Throwable> transientFaults() {
        return TransientFaults.transientFaults(ClassificationStrategy.causalChain());
    }

    public static Predicate<Throwable> transientFaults(ClassificationStrategy strategy) {
        return TransientFaults.combine(strategy, Rules.transientFaultRules());
    }

    public static final class Rules {
        private Rules() {
        }

        public static Rule<Throwable> transientSocketFaultRules() {
            return Rules.transientFaultRules().exclude(Rules.transientConnectionFaultRules());
        }

        public static Rule<Throwable> transientConnectionFaultRules() {
            Predicate[] predicateArray = new Predicate[3];
            predicateArray[0] = MalformedURLException.class::isInstance;
            predicateArray[1] = NoRouteToHostException.class::isInstance;
            predicateArray[2] = UnknownHostException.class::isInstance;
            return Rule.of(Predicates.or(ConnectException.class::isInstance, predicateArray));
        }

        public static Rule<Throwable> transientFaultRules() {
            return Rule.of(IOException.class::isInstance, throwable -> throwable instanceof SSLException && (!(throwable instanceof SSLHandshakeException) || !"Remote host closed connection during handshake".equals(throwable.getMessage())));
        }
    }
}

