/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.httpclient;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.zalando.riptide.httpclient.Closing;
import org.zalando.riptide.httpclient.EmptyInputStream;
import org.zalando.riptide.httpclient.EndOfStreamAwareInputStream;

final class ApacheClientHttpResponse
extends AbstractClientHttpResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApacheClientHttpResponse.class);
    private final HttpHeaders headers = new HttpHeaders();
    private final HttpResponse response;
    private final InputStream body;

    ApacheClientHttpResponse(HttpResponse response) throws IOException {
        this.response = response;
        this.body = ApacheClientHttpResponse.getBody(response);
        for (Header header : response.getHeaders()) {
            this.headers.add(header.getName(), header.getValue());
        }
    }

    private static InputStream getBody(HttpResponse response) throws IOException {
        HttpEntity entity = null;
        if (response instanceof HttpEntityContainer) {
            entity = ((HttpEntityContainer)response).getEntity();
        }
        if (entity == null) {
            return EmptyInputStream.EMPTY;
        }
        return new EndOfStreamAwareInputStream(entity.getContent(), (body, endOfStreamDetected) -> body.close());
    }

    public int getRawStatusCode() {
        return this.response.getCode();
    }

    @Nonnull
    public String getStatusText() {
        return this.response.getReasonPhrase();
    }

    @Nonnull
    public InputStream getBody() {
        return this.body;
    }

    @Nonnull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void close() {
        Closing.closeQuietly(this.body);
        Closing.closeQuietly(this.response);
    }
}

