/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.httpclient.ApacheClientHttpResponse;
import org.zalando.riptide.httpclient.Headers;

final class StreamingApacheClientHttpRequest
implements ClientHttpRequest,
StreamingHttpOutputMessage {
    private final HttpHeaders headers = new HttpHeaders();
    private final HttpClient client;
    private final HttpUriRequest request;

    @Nonnull
    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.request.getMethod());
    }

    @Nonnull
    public URI getURI() {
        try {
            return this.request.getUri();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nonnull
    public OutputStream getBody() {
        throw new UnsupportedOperationException();
    }

    public void setBody(StreamingHttpOutputMessage.Body body) {
        try (StreamingHttpEntity streamingHttpEntity = new StreamingHttpEntity(body);){
            this.request.setEntity((HttpEntity)streamingHttpEntity);
        }
    }

    @Nonnull
    public ClientHttpResponse execute() throws IOException {
        Headers.writeHeaders(this.headers, this.request);
        ClassicHttpResponse response = this.client.executeOpen(null, (ClassicHttpRequest)this.request, null);
        return new ApacheClientHttpResponse((HttpResponse)response);
    }

    @Generated
    public StreamingApacheClientHttpRequest(HttpClient client, HttpUriRequest request) {
        this.client = client;
        this.request = request;
    }

    private class StreamingHttpEntity
    implements HttpEntity {
        private final StreamingHttpOutputMessage.Body body;

        public boolean isRepeatable() {
            return false;
        }

        public boolean isChunked() {
            return false;
        }

        public Set<String> getTrailerNames() {
            return null;
        }

        public long getContentLength() {
            return StreamingApacheClientHttpRequest.this.headers.getContentLength();
        }

        @Nullable
        public String getContentType() {
            return Objects.toString(StreamingApacheClientHttpRequest.this.headers.getContentType());
        }

        @Nullable
        public String getContentEncoding() {
            return StreamingApacheClientHttpRequest.this.headers.getFirst("Content-Encoding");
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream stream) throws IOException {
            this.body.writeTo(stream);
        }

        public boolean isStreaming() {
            return false;
        }

        public Supplier<List<? extends Header>> getTrailers() {
            return null;
        }

        public void close() {
        }

        @Generated
        public StreamingHttpEntity(StreamingHttpOutputMessage.Body body) {
            this.body = body;
        }
    }
}

