/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.idempotency;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.idempotency.Decision;
import org.zalando.riptide.idempotency.IdempotencyDetector;

@API(status=API.Status.EXPERIMENTAL)
public final class MethodOverrideIdempotencyDetector
implements IdempotencyDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodOverrideIdempotencyDetector.class);
    private static final List<HttpMethod> validMethods = Arrays.asList(HttpMethod.values());

    @Override
    public Decision test(RequestArguments arguments, IdempotencyDetector.Test root) {
        if (arguments.getMethod() != HttpMethod.POST) {
            return Decision.NEUTRAL;
        }
        HttpMethod method = this.getOverride(arguments);
        if (method == null) {
            return Decision.NEUTRAL;
        }
        return root.test(arguments.withMethod(method));
    }

    @Nullable
    private HttpMethod getOverride(RequestArguments arguments) {
        Map headers = arguments.getHeaders();
        String name = "X-HTTP-Method-Override";
        List overrides = headers.getOrDefault("X-HTTP-Method-Override", Collections.emptyList());
        String override = overrides.stream().findFirst().orElse(null);
        if (override == null) {
            return null;
        }
        HttpMethod method = HttpMethod.valueOf((String)override);
        if (validMethods.contains(method)) {
            return method;
        }
        log.warn("Received invalid method in {} header: \"{}\"", (Object)"X-HTTP-Method-Override", (Object)override);
        return null;
    }
}

