/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.spring;

import org.apiguardian.api.API;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.util.ClassUtils;
import org.zalando.riptide.spring.RiptideProperties;
import org.zalando.riptide.spring.SettingsParser;

@API(status=API.Status.INTERNAL)
public final class SpringBoot1xSettingsParser
implements SettingsParser {
    public boolean isApplicable() {
        return ClassUtils.isPresent((String)"org.springframework.boot.bind.PropertiesConfigurationFactory", (ClassLoader)SpringBoot1xSettingsParser.class.getClassLoader());
    }

    public RiptideProperties parse(ConfigurableEnvironment environment) {
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(RiptideProperties.class);
        factory.setTargetName("riptide");
        factory.setPropertySources((PropertySources)environment.getPropertySources());
        factory.setConversionService((ConversionService)environment.getConversionService());
        return (RiptideProperties)factory.getObject();
    }
}

