/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spark.jsonschema;

import java.net.URL;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.zalando.spark.jsonschema.SchemaType;
import org.zalando.spark.jsonschema.SchemaType$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SchemaConverter$ {
    public static final SchemaConverter$ MODULE$;
    private final String SchemaFieldName;
    private final String SchemaFieldType;
    private final String SchemaFieldId;
    private final String SchemaStructContents;
    private final String SchemaArrayContents;
    private final String SchemaRoot;
    private final Map<String, Serializable> TypeMap;

    static {
        new SchemaConverter$();
    }

    public String SchemaFieldName() {
        return this.SchemaFieldName;
    }

    public String SchemaFieldType() {
        return this.SchemaFieldType;
    }

    public String SchemaFieldId() {
        return this.SchemaFieldId;
    }

    public String SchemaStructContents() {
        return this.SchemaStructContents;
    }

    public String SchemaArrayContents() {
        return this.SchemaArrayContents;
    }

    public String SchemaRoot() {
        return this.SchemaRoot;
    }

    public Map<String, Serializable> TypeMap() {
        return this.TypeMap;
    }

    public StructType convertContent(String schemaContent) {
        return this.convert(this.parseSchemaJson(schemaContent));
    }

    public StructType convert(String inputPath) {
        return this.convert(this.loadSchemaJson(inputPath));
    }

    public StructType convert(JsObject inputSchema) {
        String name = (String)this.getJsonName((JsValue)inputSchema).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "/";
            }
        });
        String typeName = this.getJsonType(inputSchema, name).typeName();
        String string = name;
        String string2 = this.SchemaRoot();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = typeName;
            String string4 = "object";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                JsObject properties = (JsObject)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)inputSchema), this.SchemaStructContents()).as((Reads)Reads$.MODULE$.JsObjectReads());
                return this.convertJsonStruct(new StructType(), properties, (List<String>)properties.keys().toList());
            }
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schema needs root level called <", "> and root type <object>. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SchemaRoot()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current root is <", "> and type is <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typeName}))).toString());
    }

    public Option<String> getJsonName(JsValue json) {
        return JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(json), this.SchemaFieldName()).asOpt((Reads)Reads$.MODULE$.StringReads());
    }

    public Option<String> getJsonId(JsValue json) {
        return JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(json), this.SchemaFieldId()).asOpt((Reads)Reads$.MODULE$.StringReads());
    }

    /*
     * WARNING - void declaration
     */
    public SchemaType getJsonType(JsObject json, String name) {
        void var3_3;
        JsValue jsValue;
        block6: {
            SchemaType schemaType;
            block5: {
                JsArray jsArray;
                Seq array;
                String id;
                block4: {
                    id = (String)this.getJsonId((JsValue)json).getOrElse((Function0)new Serializable(name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final String apply() {
                            return this.name$1;
                        }
                        {
                            this.name$1 = name$1;
                        }
                    });
                    jsValue = JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), this.SchemaFieldType()).getOrElse((JsValue)JsNull$.MODULE$);
                    if (!(jsValue instanceof JsString)) break block4;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    schemaType = new SchemaType(s, false);
                    break block5;
                }
                if (!(jsValue instanceof JsArray) || (array = (jsArray = (JsArray)jsValue).value()).size() != 2) break block6;
                schemaType = (SchemaType)array.find((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(JsValue x$1) {
                        JsValue jsValue = x$1;
                        JsString jsString = new JsString("null");
                        return jsValue != null ? !jsValue.equals(jsString) : jsString != null;
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final SchemaType apply(JsValue i) {
                        return new SchemaType((String)i.as((Reads)Reads$.MODULE$.StringReads()), true);
                    }
                }).getOrElse((Function0)new Serializable(id){
                    public static final long serialVersionUID = 0L;
                    private final String id$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrect definition of a nullable parameter at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1})));
                    }
                    {
                        this.id$1 = id$1;
                    }
                });
            }
            return schemaType;
        }
        JsNull$ jsNull$ = JsNull$.MODULE$;
        JsValue jsValue2 = jsValue;
        if (!(jsNull$ != null ? !jsNull$.equals(jsValue2) : jsValue2 != null)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No <", "> in schema at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaType$.MODULE$, var3_3})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type <", "> in schema at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsValue.toString(), var3_3})));
    }

    private JsObject parseSchemaJson(String schemaContent) {
        return (JsObject)Json$.MODULE$.parse(schemaContent).as((Reads)Reads$.MODULE$.JsObjectReads());
    }

    public JsObject loadSchemaJson(String filePath) {
        URL relPath = this.getClass().getResource(filePath);
        Predef$.MODULE$.require(relPath != null, (Function0)new Serializable(filePath){
            public static final long serialVersionUID = 0L;
            private final String filePath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path can not be reached: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filePath$1}));
            }
            {
                this.filePath$1 = filePath$1;
            }
        });
        return this.parseSchemaJson(Source$.MODULE$.fromURL(relPath, Codec$.MODULE$.fallbackSystemCodec()).mkString());
    }

    private StructType convertJsonStruct(StructType schema, JsObject json, List<String> jsonKeys) {
        List list;
        while (true) {
            list = jsonKeys;
            Nil$ nil$ = Nil$.MODULE$;
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                StructType structType = schema;
                return structType;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String head = (String)colon2.hd$1();
            List tail = colon2.tl$1();
            StructType enrichedSchema = this.addJsonField(schema, (JsObject)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), head).as((Reads)Reads$.MODULE$.JsObjectReads()), head);
            jsonKeys = tail;
            schema = enrichedSchema;
        }
        throw new MatchError(list);
    }

    private StructType addJsonField(StructType schema, JsObject json, String name) {
        AbstractDataType abstractDataType;
        block7: {
            Tuple2 tuple2;
            block5: {
                block6: {
                    block4: {
                        SchemaType fieldType = this.getJsonType(json, name);
                        abstractDataType = (AbstractDataType)this.TypeMap().apply((Object)fieldType.typeName());
                        if (!(abstractDataType instanceof DataType)) break block4;
                        DataType dataType = (DataType)abstractDataType;
                        tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)fieldType.nullable()));
                        break block5;
                    }
                    ArrayType$ arrayType$ = ArrayType$.MODULE$;
                    AbstractDataType abstractDataType2 = abstractDataType;
                    if (arrayType$ != null ? !arrayType$.equals(abstractDataType2) : abstractDataType2 != null) break block6;
                    ArrayType dataType = ArrayType$.MODULE$.apply(this.getDataType((JsValue)json, JsPath$.MODULE$.$bslash(this.SchemaArrayContents()).$bslash(this.SchemaStructContents())));
                    tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)this.getJsonType(json, name).nullable()));
                    break block5;
                }
                StructType$ structType$ = StructType$.MODULE$;
                AbstractDataType abstractDataType3 = abstractDataType;
                if (structType$ != null ? !structType$.equals(abstractDataType3) : abstractDataType3 != null) break block7;
                DataType dataType = this.getDataType((JsValue)json, JsPath$.MODULE$.$bslash(this.SchemaStructContents()));
                tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)this.getJsonType(json, name).nullable()));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                DataType dataType = (DataType)tuple22._1();
                boolean nullable = tuple22._2$mcZ$sp();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
                DataType dataType2 = (DataType)tuple24._1();
                boolean nullable2 = tuple24._2$mcZ$sp();
                return schema.add((String)this.getJsonName((JsValue)json).getOrElse((Function0)new Serializable(name){
                    public static final long serialVersionUID = 0L;
                    private final String name$2;

                    public final String apply() {
                        return this.name$2;
                    }
                    {
                        this.name$2 = name$2;
                    }
                }), dataType2, nullable2);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)abstractDataType);
    }

    private DataType getDataType(JsValue json, JsPath contentPath) {
        JsObject content = (JsObject)contentPath.asSingleJson(json).as((Reads)Reads$.MODULE$.JsObjectReads());
        return this.convertJsonStruct(new StructType(), content, (List<String>)content.keys().toList());
    }

    private SchemaConverter$() {
        MODULE$ = this;
        this.SchemaFieldName = "name";
        this.SchemaFieldType = "type";
        this.SchemaFieldId = "id";
        this.SchemaStructContents = "properties";
        this.SchemaArrayContents = "items";
        this.SchemaRoot = "/";
        this.TypeMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"string"), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"number"), (Object)DoubleType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"float"), (Object)FloatType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"integer"), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"boolean"), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"object"), (Object)StructType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"array"), (Object)ArrayType$.MODULE$)}));
    }
}

