/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spark.jsonschema;

import java.net.URL;
import java.util.NoSuchElementException;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.zalando.spark.jsonschema.SchemaType;
import org.zalando.spark.jsonschema.SchemaType$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsDefined;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsReadable;
import play.api.libs.json.JsString;
import play.api.libs.json.JsUndefined;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SchemaConverter$ {
    public static final SchemaConverter$ MODULE$;
    private final String SchemaFieldName;
    private final String SchemaFieldType;
    private final String SchemaFieldId;
    private final String SchemaStructContents;
    private final String SchemaArrayContents;
    private final String SchemaRoot;
    private final String Definitions;
    private final String Reference;
    private final Map<String, Serializable> TypeMap;
    private JsObject definitions;
    private boolean _isStrictTypingEnabled;

    static {
        new SchemaConverter$();
    }

    public String SchemaFieldName() {
        return this.SchemaFieldName;
    }

    public String SchemaFieldType() {
        return this.SchemaFieldType;
    }

    public String SchemaFieldId() {
        return this.SchemaFieldId;
    }

    public String SchemaStructContents() {
        return this.SchemaStructContents;
    }

    public String SchemaArrayContents() {
        return this.SchemaArrayContents;
    }

    public String SchemaRoot() {
        return this.SchemaRoot;
    }

    public String Definitions() {
        return this.Definitions;
    }

    public String Reference() {
        return this.Reference;
    }

    public Map<String, Serializable> TypeMap() {
        return this.TypeMap;
    }

    public JsObject definitions() {
        return this.definitions;
    }

    public void definitions_$eq(JsObject x$1) {
        this.definitions = x$1;
    }

    private boolean _isStrictTypingEnabled() {
        return this._isStrictTypingEnabled;
    }

    private void _isStrictTypingEnabled_$eq(boolean x$1) {
        this._isStrictTypingEnabled = x$1;
    }

    public SchemaConverter$ disableStrictTyping() {
        return this.setStrictTyping(false);
    }

    public SchemaConverter$ enableStrictTyping() {
        return this.setStrictTyping(true);
    }

    private SchemaConverter$ setStrictTyping(boolean b) {
        this._isStrictTypingEnabled_$eq(b);
        return this;
    }

    public StructType convertContent(String schemaContent) {
        return this.convert(this.parseSchemaJson(schemaContent));
    }

    public StructType convert(String inputPath) {
        return this.convert(this.loadSchemaJson(inputPath));
    }

    public StructType convert(JsObject inputSchema) {
        this.definitions_$eq((JsObject)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup((JsValue)inputSchema), this.Definitions()).asOpt((Reads)Reads$.MODULE$.JsObjectReads()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsObject apply() {
                return SchemaConverter$.MODULE$.definitions();
            }
        }));
        String name = (String)this.getJsonName((JsValue)inputSchema).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return SchemaConverter$.MODULE$.SchemaRoot();
            }
        });
        String typeName = this.getJsonType(inputSchema, name).typeName();
        String string = name;
        String string2 = this.SchemaRoot();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = typeName;
            String string4 = "object";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                JsObject properties = (JsObject)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup((JsValue)inputSchema), this.SchemaStructContents()).asOpt((Reads)Reads$.MODULE$.JsObjectReads()).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new NoSuchElementException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Root level of schema needs to have a [", "]-field"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaConverter$.MODULE$.SchemaStructContents()})));
                    }
                });
                return this.convertJsonStruct(new StructType(), properties, (List<String>)properties.keys().toList());
            }
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schema needs root level called <", "> and root type <object>. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SchemaRoot()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current root is <", "> and type is <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typeName}))).toString());
    }

    public Option<String> getJsonName(JsValue json) {
        return JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(json), this.SchemaFieldName()).asOpt((Reads)Reads$.MODULE$.StringReads());
    }

    public Option<String> getJsonId(JsValue json) {
        return JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(json), this.SchemaFieldId()).asOpt((Reads)Reads$.MODULE$.StringReads());
    }

    /*
     * WARNING - void declaration
     */
    public SchemaType getJsonType(JsObject json, String name) {
        void var3_3;
        JsValue jsValue;
        block13: {
            SchemaType schemaType;
            block12: {
                SchemaType schemaType2;
                String id;
                block11: {
                    id = (String)this.getJsonId((JsValue)json).getOrElse((Function0)new Serializable(name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final String apply() {
                            return this.name$1;
                        }
                        {
                            this.name$1 = name$1;
                        }
                    });
                    jsValue = JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), this.SchemaFieldType()).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final JsNull$ apply() {
                            return JsNull$.MODULE$;
                        }
                    });
                    if (!(jsValue instanceof JsString)) break block11;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    schemaType = new SchemaType(s, false);
                    break block12;
                }
                if (!(jsValue instanceof JsArray)) break block13;
                JsArray jsArray = (JsArray)jsValue;
                Seq array = jsArray.value();
                boolean nullable = array.contains((Object)new JsString("null"));
                int n = array.size();
                switch (n) {
                    case 2: {
                        if (nullable) {
                            schemaType2 = (SchemaType)array.find((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(JsValue x$1) {
                                    JsValue jsValue = x$1;
                                    JsString jsString = new JsString("null");
                                    return jsValue != null ? !jsValue.equals(jsString) : jsString != null;
                                }
                            }).map((Function1)new Serializable(nullable){
                                public static final long serialVersionUID = 0L;
                                private final boolean nullable$1;

                                public final SchemaType apply(JsValue i) {
                                    return new SchemaType((String)i.as((Reads)Reads$.MODULE$.StringReads()), this.nullable$1);
                                }
                                {
                                    this.nullable$1 = nullable$1;
                                }
                            }).getOrElse((Function0)new Serializable(id){
                                public static final long serialVersionUID = 0L;
                                private final String id$1;

                                public final Nothing$ apply() {
                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrect definition of a nullable parameter at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1})));
                                }
                                {
                                    this.id$1 = id$1;
                                }
                            });
                            break;
                        }
                    }
                    default: {
                        if (this._isStrictTypingEnabled()) {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type definition <", "> in schema at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array.toString(), id})));
                        }
                        schemaType2 = new SchemaType("string", nullable);
                        break;
                    }
                    case 1: {
                        if (nullable) {
                            throw new IllegalArgumentException("Null type only is not supported");
                        }
                        schemaType2 = new SchemaType((String)((JsReadable)array.apply(0)).as((Reads)Reads$.MODULE$.StringReads()), nullable);
                    }
                }
                schemaType = schemaType2;
            }
            return schemaType;
        }
        if (JsNull$.MODULE$.equals(jsValue)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No <", "> in schema at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaType$.MODULE$, var3_3})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type <", "> in schema at <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsValue.toString(), var3_3})));
    }

    private JsObject parseSchemaJson(String schemaContent) {
        return (JsObject)Json$.MODULE$.parse(schemaContent).as((Reads)Reads$.MODULE$.JsObjectReads());
    }

    public JsObject loadSchemaJson(String filePath) {
        URL relPath = this.getClass().getResource(filePath);
        Predef$.MODULE$.require(relPath != null, (Function0)new Serializable(filePath){
            public static final long serialVersionUID = 0L;
            private final String filePath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path can not be reached: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filePath$1}));
            }
            {
                this.filePath$1 = filePath$1;
            }
        });
        return this.parseSchemaJson(Source$.MODULE$.fromURL(relPath, Codec$.MODULE$.fallbackSystemCodec()).mkString());
    }

    private StructType convertJsonStruct(StructType schema, JsObject json, List<String> jsonKeys) {
        List list;
        while (true) {
            if (Nil$.MODULE$.equals(list = jsonKeys)) {
                StructType structType = schema;
                return structType;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String head = (String)colon2.head();
            List tail = colon2.tl$1();
            StructType enrichedSchema = this.addJsonField(schema, (JsObject)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), head).as((Reads)Reads$.MODULE$.JsObjectReads()), head);
            jsonKeys = tail;
            schema = enrichedSchema;
        }
        throw new MatchError(list);
    }

    public JsPath traversePath(List<String> loc, JsPath path) {
        List list;
        while ((list = loc) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String head = (String)colon2.head();
            List tail = colon2.tl$1();
            path = path.$bslash(head);
            loc = tail;
        }
        if (Nil$.MODULE$.equals(list)) {
            JsPath jsPath = path;
            return jsPath;
        }
        throw new MatchError(list);
    }

    private JsObject checkRefs(JsObject inputJson) {
        Option option;
        block8: {
            JsObject jsObject;
            block7: {
                block5: {
                    JsLookupResult jsLookupResult;
                    JsString loc;
                    block6: {
                        JsObject jsObject2;
                        JsValue jsValue;
                        int n;
                        Option schemaRef = JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup((JsValue)inputJson), this.Reference()).asOpt((Reads)Reads$.MODULE$.JsStringReads());
                        option = schemaRef;
                        if (!(option instanceof Some)) break block5;
                        Some some = (Some)option;
                        loc = (JsString)some.x();
                        String searchDefinitions = new StringBuilder().append((Object)this.Definitions()).append((Object)"/").toString();
                        int n2 = loc.value().indexOf(searchDefinitions);
                        if (-1 == n2) {
                            throw new NoSuchElementException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field with name [", "] requires path with [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Reference(), searchDefinitions})));
                        }
                        int n3 = n2;
                        int defIndex = n = n3 + searchDefinitions.length();
                        List pathNodes = Predef$.MODULE$.refArrayOps((Object[])((String)new StringOps(Predef$.MODULE$.augmentString(loc.value())).drop(defIndex)).split("/")).toList();
                        jsLookupResult = this.traversePath((List<String>)pathNodes, (JsPath)JsPath$.MODULE$).asSingleJson((JsValue)this.definitions());
                        if (!(jsLookupResult instanceof JsDefined)) break block6;
                        JsValue v = jsValue = jsLookupResult == null ? null : ((JsDefined)jsLookupResult).value();
                        jsObject = jsObject2 = (JsObject)v.as((Reads)Reads$.MODULE$.JsObjectReads());
                        break block7;
                    }
                    if (jsLookupResult instanceof JsUndefined) {
                        throw new NoSuchElementException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path [", "] not found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{loc, this.Definitions()})));
                    }
                    throw new MatchError((Object)jsLookupResult);
                }
                if (!None$.MODULE$.equals(option)) break block8;
                jsObject = inputJson;
            }
            return jsObject;
        }
        throw new MatchError((Object)option);
    }

    private StructType addJsonField(StructType schema, JsObject inputJson, String name) {
        JsObject json = this.checkRefs(inputJson);
        Tuple2<DataType, Object> tuple2 = this.getFieldType(json, name);
        if (tuple2 != null) {
            Tuple2 tuple22;
            DataType dataType = (DataType)tuple2._1();
            boolean nullable = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
            DataType dataType2 = (DataType)tuple23._1();
            boolean nullable2 = tuple23._2$mcZ$sp();
            return schema.add((String)this.getJsonName((JsValue)json).getOrElse((Function0)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$2;

                public final String apply() {
                    return this.name$2;
                }
                {
                    this.name$2 = name$2;
                }
            }), dataType2, nullable2);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<DataType, Object> getFieldType(JsObject json, String name) {
        AbstractDataType abstractDataType;
        block5: {
            Tuple2 tuple2;
            block3: {
                block4: {
                    block2: {
                        SchemaType fieldType = this.getJsonType(json, name);
                        abstractDataType = (AbstractDataType)this.TypeMap().apply((Object)fieldType.typeName());
                        if (!(abstractDataType instanceof DataType)) break block2;
                        DataType dataType = (DataType)abstractDataType;
                        tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)fieldType.nullable()));
                        break block3;
                    }
                    if (!ArrayType$.MODULE$.equals(abstractDataType)) break block4;
                    JsObject innerJson = this.checkRefs((JsObject)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), this.SchemaArrayContents()).as((Reads)Reads$.MODULE$.JsObjectReads()));
                    Tuple2<DataType, Object> innerJsonType = this.getFieldType(innerJson, "");
                    ArrayType dataType = new ArrayType((DataType)innerJsonType._1(), innerJsonType._2$mcZ$sp());
                    tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)this.getJsonType(json, name).nullable()));
                    break block3;
                }
                if (!StructType$.MODULE$.equals(abstractDataType)) break block5;
                DataType dataType = this.getDataType(json, JsPath$.MODULE$.$bslash(this.SchemaStructContents()));
                tuple2 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)this.getJsonType(json, name).nullable()));
            }
            return tuple2;
        }
        throw new MatchError((Object)abstractDataType);
    }

    private DataType getDataType(JsObject inputJson, JsPath contentPath) {
        JsLookupResult jsLookupResult;
        block4: {
            JsObject jsObject;
            block3: {
                block2: {
                    JsValue jsValue;
                    JsObject json = this.checkRefs(inputJson);
                    jsLookupResult = contentPath.asSingleJson((JsValue)json);
                    if (!(jsLookupResult instanceof JsDefined)) break block2;
                    JsValue v = jsValue = jsLookupResult == null ? null : ((JsDefined)jsLookupResult).value();
                    jsObject = (JsObject)v.as((Reads)Reads$.MODULE$.JsObjectReads());
                    break block3;
                }
                if (!(jsLookupResult instanceof JsUndefined)) break block4;
                jsObject = JsObject$.MODULE$.apply((Seq)Seq$.MODULE$.empty());
            }
            JsObject content = jsObject;
            return this.convertJsonStruct(new StructType(), content, (List<String>)content.keys().toList());
        }
        throw new MatchError((Object)jsLookupResult);
    }

    private SchemaConverter$() {
        MODULE$ = this;
        this.SchemaFieldName = "name";
        this.SchemaFieldType = "type";
        this.SchemaFieldId = "id";
        this.SchemaStructContents = "properties";
        this.SchemaArrayContents = "items";
        this.SchemaRoot = "/";
        this.Definitions = "definitions";
        this.Reference = "$ref";
        this.TypeMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)DoubleType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"float"), (Object)FloatType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"integer"), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"boolean"), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"object"), (Object)StructType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"array"), (Object)ArrayType$.MODULE$)}));
        this.definitions = JsObject$.MODULE$.apply((Seq)Seq$.MODULE$.empty());
        this._isStrictTypingEnabled = true;
    }
}

